/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.SQLStates;
import Altibase.jdbc.driver.cm;
import Altibase.jdbc.driver.ex;
import Altibase.jdbc.driver.idnCharSet;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

class ABEncoder
extends idnCharSet
implements cm,
SQLStates {
    private short csId;
    private CharsetEncoder ce;
    private CharsetDecoder cd;
    private DateFormat fmt_timestamp01;
    private DateFormat fmt_timestamp02;
    private DateFormat fmt_time;
    private DateFormat fmt_date;

    ABEncoder(String cs) throws SQLException {
        this.setCharSet(cs);
        this.setDateFormat(null);
    }

    final void setDateFormat(String aDataeFormat) {
        this.fmt_date = new SimpleDateFormat("hh:mm:ss.SSSSSS");
        this.fmt_time = new SimpleDateFormat("hh:mm:ss.SSSSSS");
        this.fmt_timestamp01 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        this.fmt_timestamp02 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSSSSS");
    }

    final boolean decode(ByteBuffer bb, CharBuffer cb) throws SQLException {
        CoderResult cr = this.cd.decode(bb, cb, true);
        ex.test(cr.isOverflow(), (short)35);
        if (cr.isUnmappable()) {
            char data = (char)bb.get();
            cb.put(data);
            return this.decode(bb, cb);
        }
        if (cr.isMalformed()) {
            char data = (char)bb.get();
            cb.put(data);
            return this.decode(bb, cb);
        }
        return cr.isUnderflow();
    }

    final boolean encode(CharBuffer cb, ByteBuffer bb) throws SQLException {
        CoderResult cr = this.ce.encode(cb, bb, true);
        return cr.isOverflow();
    }

    final short getId() {
        return this.csId;
    }

    final synchronized java.sql.Date parseDate(String s) throws SQLException {
        try {
            return java.sql.Date.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            ParsePosition pp = new ParsePosition(0);
            Date dt = this.fmt_date.parse(s, pp);
            if (dt == null && s.length() > 0 && s.charAt(2) == '-' && s.charAt(6) == '-') {
                int day = ABEncoder.str2int(s, 0, 2);
                int month = 12;
                int test = s.charAt(3) << 16 | s.charAt(4) << 8 | s.charAt(5);
                switch (test) {
                    case 4866382: {
                        month = 0;
                        break;
                    }
                    case 4605250: {
                        month = 1;
                        break;
                    }
                    case 5062994: {
                        month = 2;
                        break;
                    }
                    case 4280402: {
                        month = 3;
                        break;
                    }
                    case 5063001: {
                        month = 4;
                        break;
                    }
                    case 4871502: {
                        month = 5;
                        break;
                    }
                    case 4871500: {
                        month = 6;
                        break;
                    }
                    case 4281671: {
                        month = 7;
                        break;
                    }
                    case 5457232: {
                        month = 8;
                        break;
                    }
                    case 5194580: {
                        month = 9;
                        break;
                    }
                    case 5132118: {
                        month = 10;
                        break;
                    }
                    case 0x444543: {
                        month = 11;
                        break;
                    }
                    default: {
                        ex.exception((short)39);
                    }
                }
                int year = 100 + ABEncoder.str2int(s, 7, 9);
                return new java.sql.Date(year, month, day);
            }
            return new java.sql.Date(dt.getTime());
        }
    }

    final synchronized Time parseTime(String s) throws SQLException {
        try {
            return Time.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            Date dt = this.fmt_time.parse(s, new ParsePosition(0));
            ex.test(dt == null, (short)39);
            return new Time(dt.getTime());
        }
    }

    final synchronized Timestamp parseTimestamp(String s) throws SQLException {
        try {
            return Timestamp.valueOf(s);
        }
        catch (IllegalArgumentException ie) {
            Date dt = null;
            if (dt == null) {
                try {
                    dt = this.fmt_timestamp01.parse(s, new ParsePosition(0));
                }
                catch (IllegalArgumentException e) {}
            } else if (dt == null) {
                try {
                    dt = this.fmt_timestamp02.parse(s, new ParsePosition(0));
                }
                catch (IllegalArgumentException e) {}
            } else if (dt == null) {
                try {
                    dt = this.fmt_time.parse(s, new ParsePosition(0));
                }
                catch (IllegalArgumentException e) {}
            } else if (dt == null) {
                try {
                    dt = this.fmt_date.parse(s, new ParsePosition(0));
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            ex.test(dt == null, (short)39);
            return new Timestamp(dt.getTime());
        }
    }

    final void setCharSet(String csn) throws SQLException {
        this.csId = csn != null ? ABEncoder.getId(csn) : (short)0;
        Charset cs = ABEncoder.getCharset(this.csId);
        this.ce = cs.newEncoder();
        this.cd = cs.newDecoder();
        this.ce.onMalformedInput(CodingErrorAction.REPLACE);
        this.ce.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.cd.onMalformedInput(CodingErrorAction.REPORT);
        this.cd.onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    static final int str2int(String s, int from, int to) throws SQLException {
        int i = 0;
        while (from <= to) {
            byte c = (byte)s.charAt(from);
            ex.test(c < 48 || c > 57, (short)42);
            c = (byte)(c - 48);
            i = i * 10 + c;
            ++from;
        }
        return i;
    }

    public final String format(Timestamp timestamp) {
        return this.fmt_timestamp02.format(timestamp);
    }

    public final String format(Time time) {
        return this.fmt_time.format(time);
    }

    public final String format(java.sql.Date date) {
        return this.fmt_date.format(date);
    }

    public String toString() {
        return this.ce.charset().toString();
    }

    public int maxBytesPerChar() {
        return (int)this.ce.maxBytesPerChar() + 1;
    }

    public String getCharset() {
        try {
            return ABEncoder.getCharset(this.getId()).name();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return "";
        }
    }
}

