/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.ABConnection;
import Altibase.jdbc.driver.ABRPreparedStatement;
import Altibase.jdbc.driver.ABRSavepoint;
import Altibase.jdbc.driver.ABRStatement;
import Altibase.jdbc.driver.SQLStates;
import Altibase.jdbc.driver.ex;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;

public class ABRConnection
extends ABConnection {
    protected boolean autocommit;
    protected Connection s_con;
    protected Properties s_prop;
    protected String s_url;

    public ABRConnection(Properties p) throws SQLException {
        super(p);
        this.s_url = p.getProperty("SLAVE_URL");
        this.s_con = null;
        if (this.s_url != null) {
            Enumeration<?> e = p.propertyNames();
            this.s_prop = new Properties();
            while (e.hasMoreElements()) {
                String i = (String)e.nextElement();
                if (!i.startsWith("SLAVE_")) continue;
                String key = i.substring(6);
                String val = p.getProperty(i);
                this.s_prop.setProperty(key, val);
            }
        } else {
            throw new SQLException(SQLStates.mFixmsg[21]);
        }
        this.s_con = DriverManager.getConnection(this.s_url, this.s_prop);
        this.s_con.setAutoCommit(false);
        super.setAutoCommit(false);
        this.autocommit = true;
    }

    public synchronized void close() throws SQLException {
        this.s_con.close();
        super.close();
    }

    public synchronized void commit() throws SQLException {
        super.commit();
        this.s_con.commit();
    }

    public synchronized Statement createStatement() throws SQLException {
        return new ABRStatement(this);
    }

    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ABRStatement(this, resultSetType, resultSetConcurrency);
    }

    public synchronized boolean getAutoCommit() {
        return this.autocommit;
    }

    public synchronized boolean isClosed() throws SQLException {
        return super.isClosed() && this.s_con.isClosed();
    }

    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        return new ABRPreparedStatement(this, sql);
    }

    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        ex.test(resultSetType == 1005 || resultSetConcurrency == 1008, (short)103);
        return new ABRPreparedStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        super.releaseSavepoint(savepoint);
        this.s_con.releaseSavepoint(savepoint);
    }

    public synchronized void rollback() throws SQLException {
        super.rollback();
        this.s_con.rollback();
    }

    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        super.rollback(savepoint);
        this.s_con.rollback(savepoint);
    }

    public synchronized void setAutoCommit(boolean ac) throws SQLException {
        this.autocommit = ac;
    }

    public synchronized Savepoint setSavepoint() throws SQLException {
        return this.setSavepoint(null);
    }

    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        ex.test(this.getAutoCommit(), (short)31);
        return new ABRSavepoint(this, name);
    }
}

