/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.ABConnection;
import Altibase.jdbc.driver.ABEncoder;
import Altibase.jdbc.driver.ABResultSet;
import Altibase.jdbc.driver.SQLStates;
import Altibase.jdbc.driver.cm;
import Altibase.jdbc.driver.cmo;
import Altibase.jdbc.driver.ex;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;

public class ABStatement
extends ArrayList
implements Statement,
SQLStates,
cm,
cmo {
    static final long serialVersionUID = 1L;
    static final byte ALLOCATED_STATE = 0;
    static final byte PREPARED_STATE = 1;
    static final byte EXECUTED_STATE = 2;
    static final short FETCH_MIN = 0;
    static final short FETCH_DEF = 0;
    static final short FETCH_MAX = Short.MAX_VALUE;
    protected byte mState;
    protected String mQueryString;
    protected ex wn;
    protected ArrayList mBatch;
    protected int mResultSetID;
    protected int id;
    protected long mUpdateCount;
    protected ABConnection mConnection;
    private int mCnUID;
    protected int mStmtType;
    protected int maxFieldSize;
    protected int mRowsMax;
    protected short mFetchSize;
    protected int rsC = 1007;
    protected int rsH = 2;
    protected int rsT = 1003;
    static final int SCROLL_INSENSITIVE_DEFAULT_FETCH_SIZE = 1024;

    ABStatement(ABConnection aConnection) throws SQLException {
        super(1);
        this.setFetchSize(aConnection.getProperty("FETCH_ENOUGH", (short)0));
        this.mConnection = aConnection;
        this.mCnUID = this.mConnection.getUID();
        this.mState = 0;
        this.wn = new ex();
        this.mUpdateCount = -1L;
        this.mResultSetID = 0;
        this.mRowsMax = 0;
    }

    ABStatement(ABConnection aConnection, int aResultSetType, int aResultSetConcurrency) throws SQLException {
        this(aConnection);
        switch (aResultSetType) {
            case 1004: {
                this.mFetchSize = (short)1024;
            }
            case 1003: {
                this.rsT = aResultSetType;
                break;
            }
            default: {
                ex.exception((short)30, SQLStates.mFixmsg[25]);
            }
        }
        switch (aResultSetConcurrency) {
            case 1007: {
                this.rsC = 1007;
                break;
            }
            default: {
                this.wn.warning((short)10, SQLStates.mWarmsg[0]);
            }
        }
    }

    public void addBatch(String aSql) throws SQLException {
        if (this.mBatch == null) {
            this.mQueryString = null;
            this.mBatch = new ArrayList();
        }
        this.mBatch.add(aSql.trim());
    }

    public void cancel() throws SQLException {
        this.mResultSetID = 0;
        this.wn.clearWarnings();
        this.mUpdateCount = -1L;
        switch (this.mState) {
            case 0: {
                this.mQueryString = null;
            }
            case 1: {
                break;
            }
            case 2: {
                this.mConnection.cancel(this);
                super.clear();
            }
        }
        this.mState = 0;
    }

    public void clearBatch() throws SQLException {
        if (this.mBatch != null) {
            this.mBatch.clear();
            this.mBatch = null;
        }
    }

    public void clearWarnings() throws SQLException {
        this.wn.clearWarnings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        try {
            if (this.id != 0 && this.mCnUID == this.mConnection.getUID()) {
                this.mConnection.free(this);
            }
            Object var2_1 = null;
            this.mBatch = null;
            this.mQueryString = null;
            this.id = 0;
            this.mState = 0;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.mBatch = null;
            this.mQueryString = null;
            this.id = 0;
            this.mState = 0;
            throw throwable;
        }
    }

    public boolean execute(String aSqlString) throws SQLException {
        this.cancel();
        this.mQueryString = aSqlString;
        this.mState = (byte)2;
        this.mConnection.exec(this);
        return this.isSelect();
    }

    public boolean execute(String aSqlString, int autoGeneratedKeys) throws SQLException {
        this.cancel();
        this.mQueryString = aSqlString;
        switch (autoGeneratedKeys) {
            case 1: {
                ex.exception((short)103);
                break;
            }
            case 2: {
                this.mConnection.exec(this);
                break;
            }
            default: {
                ex.exception((short)84);
            }
        }
        return this.isSelect();
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        ex.exception((short)30);
        return false;
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        ex.exception((short)30);
        return false;
    }

    public int[] executeBatch() throws SQLException {
        SQLException sException = null;
        int size = this.mBatch != null ? this.mBatch.size() : 0;
        int[] counts = new int[size];
        this.cancel();
        this.mState = (byte)2;
        if (this.mConnection.getAutoCommit()) {
            this.wn.warning((short)1, SQLStates.mWarmsg[1]);
        }
        for (int i = 0; i < size; ++i) {
            try {
                this.mQueryString = (String)this.mBatch.get(i);
                counts[i] = -3;
                this.mConnection.exec(this);
                counts[i] = (int)this.mUpdateCount;
                continue;
            }
            catch (SQLException e) {
                if (sException == null) {
                    sException = e;
                    continue;
                }
                sException.setNextException(e);
            }
        }
        if (sException != null) {
            BatchUpdateException sExceptBatch = new BatchUpdateException(SQLStates.mFixmsg[45], SQLStates.status[65], counts);
            sExceptBatch.setNextException(sException);
            throw sExceptBatch;
        }
        return counts;
    }

    public synchronized ResultSet executeQuery(String aSqlString) throws SQLException {
        this.cancel();
        this.mQueryString = aSqlString;
        this.mState = (byte)2;
        this.mConnection.writeDirectExecuteFetchReq(this);
        ex.test(!this.isSelect(), (short)72, SQLStates.mFixmsg[26]);
        return this.getDefaultResultSet();
    }

    public synchronized ABResultSet getDefaultResultSet() throws SQLException {
        ABResultSet rst = (ABResultSet)super.get(0);
        return rst;
    }

    public synchronized int executeUpdate(String aSql) throws SQLException {
        this.cancel();
        this.mQueryString = aSql;
        this.mState = (byte)2;
        this.mConnection.exec(this);
        ex.test(this.isSelect(), (short)72, SQLStates.mFixmsg[27]);
        return (int)this.mUpdateCount;
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        ex.exception((short)30);
        return 0;
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        ex.exception((short)30);
        return 0;
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        ex.exception((short)30);
        return 0;
    }

    public Connection getConnection() {
        return this.mConnection;
    }

    public String getExplainPlan() throws SQLException {
        return this.mConnection.getExplainPlan(this);
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public int getFetchSize() {
        return this.mFetchSize;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        ex.exception((short)30);
        return null;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() {
        return this.mRowsMax;
    }

    public boolean getMoreResults() throws SQLException {
        if (this.mResultSetID + 1 < this.getResultSetCount()) {
            ++this.mResultSetID;
            return true;
        }
        return false;
    }

    public boolean getMoreResults(int current) throws SQLException {
        this.mResultSetID = current;
        return this.getMoreResults();
    }

    public int getQueryTimeout() throws SQLException {
        return this.mConnection.getQueryTimeout();
    }

    public ResultSet getResultSet() throws SQLException {
        if (super.isEmpty()) {
            return null;
        }
        ABResultSet rst = (ABResultSet)super.get(this.mResultSetID);
        return rst;
    }

    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    public int getResultSetHoldability() throws SQLException {
        return this.rsH;
    }

    public int getResultSetType() throws SQLException {
        return this.rsT;
    }

    public int getUpdateCount() throws SQLException {
        int sResult = super.isEmpty() ? (int)this.mUpdateCount : -1;
        this.mUpdateCount = -1L;
        return sResult;
    }

    public final SQLWarning getWarnings() throws SQLException {
        return this.wn.getWarnings();
    }

    public void setCursorName(String unused) throws SQLException {
        ex.exception((short)30);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    public void setFetchDirection(int direction) throws SQLException {
        ex.test(direction != 1000, (short)84);
    }

    public void setFetchSize(int rows) throws SQLException {
        ex.test(rows < 0 || rows >= Short.MAX_VALUE, (short)84);
        if (this.rsT == 1003) {
            this.mFetchSize = (short)rows;
        }
    }

    public void setMaxFieldSize(int max) throws SQLException {
        ex.test(max < 0, (short)84);
        this.maxFieldSize = max;
    }

    public void setMaxRows(int max) throws SQLException {
        this.mRowsMax = max;
    }

    public void setQueryTimeout(int timeout) throws SQLException {
        ex.test(this.mConnection == null, (short)26);
        this.mConnection.setQueryTimeout(this.id, timeout);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        sb.append(this.id);
        sb.append(':');
        switch (this.mState) {
            case 0: {
                sb.append("A");
                break;
            }
            case 1: {
                sb.append("P");
                break;
            }
            case 2: {
                sb.append("E");
            }
        }
        sb.append(']');
        if (this.mQueryString != null) {
            sb.append(this.mQueryString);
        }
        return sb.toString();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }

    final ABEncoder getEncoder() {
        return this.mConnection.getEncoder();
    }

    int getID() {
        return this.id;
    }

    void setID(int stmtId) {
        this.id = stmtId;
    }

    boolean isSelect() {
        return this.mStmtType == 65536 || this.mStmtType == 65545;
    }

    void setResultSetCount(short aResultSetCount) throws SQLException {
        super.clear();
        for (short i = 0; aResultSetCount > i; i = (short)(i + 1)) {
            ABResultSet sResultSet = new ABResultSet(this, i);
            sResultSet.clear();
            this.add(sResultSet);
        }
    }

    int getResultSetCount() throws SQLException {
        return this.size();
    }

    int getCurrentResultSetID() throws SQLException {
        return this.mResultSetID;
    }

    void setParamsCount(short params) throws SQLException {
        ex.test(params > 0, (short)106, SQLStates.mFixmsg[28]);
    }

    final int setStmtType(int type) {
        this.mStmtType = type;
        return this.mStmtType;
    }

    void setUpdateCount(long count, int row) throws SQLException {
        this.mUpdateCount = count;
    }
}

