/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.ABEncoder;
import Altibase.jdbc.driver.ABSerialize;
import Altibase.jdbc.driver.ABTypes;
import Altibase.jdbc.driver.SQLStates;
import Altibase.jdbc.driver.cmb;
import Altibase.jdbc.driver.cmp;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

class ABString
extends Number
implements SQLStates,
ABSerialize,
ABTypes,
Serializable {
    static final long serialVersionUID = 13L;
    private ABEncoder en;
    private CharBuffer mCharBuffer;
    int mMaxCapacity;

    ABString(ABEncoder encoder, int capacity) throws SQLException {
        this.en = encoder;
        this.mMaxCapacity = capacity;
        this.mCharBuffer = CharBuffer.allocate(0);
        this.setNull();
    }

    ABString(ABEncoder encoder, String x) throws SQLException {
        this(encoder, x.length() + 16);
        this.set(x);
    }

    final CharBuffer allocCharBuffer(int aByteSize) {
        if (aByteSize > this.mCharBuffer.capacity()) {
            int sAllocSize = aByteSize * 2;
            sAllocSize = sAllocSize > this.mMaxCapacity ? this.mMaxCapacity : sAllocSize;
            this.mCharBuffer = CharBuffer.allocate(sAllocSize).put(this.mCharBuffer);
            this.mCharBuffer.clear();
        }
        return this.mCharBuffer;
    }

    public byte byteValue() {
        return Byte.parseByte(this.toString());
    }

    public final Date dateValue() throws SQLException {
        Date v = null;
        if (!this.isNull()) {
            v = this.en.parseDate(this.trim());
        }
        return v;
    }

    public double doubleValue() {
        return Double.parseDouble(this.toString());
    }

    public float floatValue() {
        return Float.parseFloat(this.toString());
    }

    public byte[] getBytes() throws SQLException {
        byte[] v = null;
        if (this.mCharBuffer.limit() > 0) {
            try {
                v = this.toString().getBytes(this.en.getCharset());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return v;
    }

    public BigDecimal getNumeric() {
        return new BigDecimal(this.toString());
    }

    public int intValue() {
        return Integer.parseInt(this.toString());
    }

    public boolean isNull() {
        return 0 == this.mCharBuffer.limit();
    }

    public boolean isTrue() {
        if (this.mCharBuffer.length() > 0) {
            switch (this.mCharBuffer.get(0)) {
                case '1': 
                case 'T': 
                case 't': {
                    return true;
                }
            }
        }
        return false;
    }

    public long longValue() {
        return Long.parseLong(this.toString());
    }

    public void read(cmp chn) throws SQLException {
        boolean next = false;
        this.mCharBuffer.clear();
        ByteBuffer appendBuffer = ByteBuffer.allocate(this.mMaxCapacity);
        do {
            cmb cbr = chn.remain();
            int offset = cbr.intValue();
            cbr = chn.remain();
            short size = cbr.shortValue();
            cbr = chn.remain();
            next = cbr.get() == 0;
            int rem = cbr.remaining();
            if (rem <= 0) continue;
            rem = cbr.limit();
            ByteBuffer bb = cbr.limit(cbr.position() + size);
            appendBuffer.put(bb);
            bb = cbr.limit(rem);
        } while (next);
        this.allocCharBuffer(appendBuffer.position());
        appendBuffer.limit(appendBuffer.position());
        appendBuffer.rewind();
        this.en.decode(appendBuffer, this.mCharBuffer);
        this.mCharBuffer.limit(this.mCharBuffer.position());
        this.mCharBuffer.position(0);
    }

    public void in_read(cmp chn) throws SQLException {
        this.mCharBuffer.clear();
        cmb cbr = chn.remain();
        int size = cbr.intValue();
        this.allocCharBuffer(size);
        cbr = chn.remain();
        int rem = cbr.limit();
        ByteBuffer bb = cbr.limit(cbr.position() + size);
        this.en.decode(bb, this.mCharBuffer);
        cbr.limit(rem);
        this.mCharBuffer.limit(this.mCharBuffer.position());
        this.mCharBuffer.position(0);
    }

    public CharBuffer set(String str) throws SQLException {
        this.setNull();
        if (str != null) {
            int length = str.length();
            this.ensure(length);
            str.getChars(0, length, this.mCharBuffer.array(), 0);
            this.mCharBuffer.limit(length);
        }
        return this.mCharBuffer;
    }

    public final void setNull() {
        this.mCharBuffer.clear();
        this.mCharBuffer.limit(0);
    }

    public short shortValue() {
        return Short.parseShort(this.toString());
    }

    public final Timestamp timestampValue() throws SQLException {
        Timestamp v = null;
        if (!this.isNull()) {
            v = this.en.parseTimestamp(this.trim());
        }
        return v;
    }

    public final Time timeValue() throws SQLException {
        Time v = null;
        if (!this.isNull()) {
            v = this.en.parseTime(this.trim());
        }
        return v;
    }

    public String toString() {
        String str = null;
        if (this.mCharBuffer.limit() > 0) {
            str = new String(this.mCharBuffer.array(), 0, this.mCharBuffer.limit());
        }
        return str;
    }

    public void write(cmp chn) throws SQLException {
        boolean isOverflow = true;
        int offset = 0;
        while (isOverflow) {
            cmb cbw = chn.next();
            int pos = cbw.mark(7);
            isOverflow = this.en.encode(this.mCharBuffer, cbw.buffer());
            int size = cbw.position() - pos;
            pos = cbw.position();
            cbw.reset();
            cbw.putInt(offset);
            cbw.putShort((short)size);
            cbw.putBool(!isOverflow);
            cbw.position(pos);
            offset += size;
        }
        this.mCharBuffer.position(0);
    }

    final void encoder(ABEncoder coder) {
        this.en = coder;
    }

    final CharBuffer ensure(int aCapacity) {
        if (aCapacity > this.mCharBuffer.capacity()) {
            this.mCharBuffer = CharBuffer.allocate(aCapacity).put(this.mCharBuffer);
            if (aCapacity > this.mMaxCapacity) {
                this.mMaxCapacity = aCapacity;
            }
        }
        return this.mCharBuffer;
    }

    final String trim() {
        for (int i = this.mCharBuffer.limit() - 1; i > 0; --i) {
            if (this.mCharBuffer.get(i) == ' ') continue;
            return new String(this.mCharBuffer.array(), 0, ++i);
        }
        return null;
    }

    public static char[] getValue(StringBuffer sb) throws Exception {
        Method method = sb.getClass().getDeclaredMethod("getValue", null);
        method.setAccessible(true);
        Object[] params = null;
        Object result = method.invoke((Object)sb, params);
        return (char[])result;
    }
}

