/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.ABConnectionPoolDataSource;
import Altibase.jdbc.driver.ABXADataSource;
import Altibase.jdbc.driver.DataSource;
import Altibase.jdbc.driver.SQLStates;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class DataSourceObjectFactory
implements ObjectFactory {
    public synchronized Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) throws Exception {
        Reference ref = (Reference)obj;
        String dbName = (String)ref.get("databaseName").getContent();
        if (dbName == null) {
            throw new IllegalArgumentException(SQLStates.mFixmsg[40]);
        }
        DataSource ds = null;
        if (ref.getClassName().endsWith(".DataSource")) {
            ds = new DataSource();
        } else if (ref.getClassName().endsWith("ConnectionPoolDataSource")) {
            ds = new ABConnectionPoolDataSource();
            ((ABConnectionPoolDataSource)ds).setMinPoolSize(Integer.parseInt(this.get(ref, "minPoolSize", "0")));
            ((ABConnectionPoolDataSource)ds).setMaxPoolSize(Integer.parseInt(this.get(ref, "maxPoolSize", "0")));
            ((ABConnectionPoolDataSource)ds).setPropertyCycle(Integer.parseInt(this.get(ref, "propertyCycle", "0")));
            ((ABConnectionPoolDataSource)ds).setMaxIdleTime(Integer.parseInt(this.get(ref, "maxIdleTime", "0")));
            ((ABConnectionPoolDataSource)ds).setInitialPoolSize(Integer.parseInt(this.get(ref, "initialPoolSize", "4")));
        } else if (ref.getClassName().endsWith("XADataSource")) {
            ds = new ABXADataSource();
        } else {
            return null;
        }
        ds.setDatabaseName(dbName);
        ds.setUser(this.get(ref, "user", null));
        ds.setPassword(this.get(ref, "password", null));
        ds.setServerName(this.get(ref, "serverName", "localhost"));
        try {
            ds.setPortNumber(Integer.parseInt(this.get(ref, "portNumber", "20300")));
        }
        catch (NumberFormatException ne) {
            throw new SQLException(SQLStates.mFixmsg[41], "08001");
        }
        String enc = this.get(ref, "encoding", null);
        if (enc != null) {
            ds.setEncoding(enc);
        }
        return ds;
    }

    private String get(Reference ref, String name, String defaultValue) {
        RefAddr ra = ref.get(name);
        if (ra == null) {
            return defaultValue;
        }
        return (String)ra.getContent();
    }
}

