/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.GeometryList;
import Altibase.jdbc.driver.Point;
import Altibase.jdbc.driver.aTokenizer;
import java.sql.SQLException;

public class LineString
extends GeometryList {
    static final long serialVersionUID = 30303L;

    public LineString() throws SQLException {
        super((byte)2, 0);
    }

    public LineString(Point[] points) throws SQLException {
        super((byte)2, points.length);
        this.mGeometrySize += points.length * 16;
        for (int i = 0; i < this.capacity; ++i) {
            super.add(i, points[i]);
            this.resetMBR(points[i]);
        }
    }

    public LineString(String s) throws SQLException {
        super((byte)2);
        s = s.trim().toUpperCase();
        if (s.startsWith(this.mGeometryName)) {
            s = s.substring(this.mGeometryName.length()).trim();
        }
        aTokenizer t = new aTokenizer(aTokenizer.removePara(s), ',');
        this.setSize(t.size());
        this.mGeometrySize += this.capacity * 16;
        for (int i = 0; i < this.capacity; ++i) {
            Point p = new Point(t.getToken(i));
            this.add(p);
            this.resetMBR(p);
        }
    }

    public Object clone() {
        try {
            LineString ret = new LineString();
            for (int i = 0; i < this.size(); ++i) {
                ret.add(((Point)this.get(i)).clone());
            }
            return ret;
        }
        catch (SQLException se) {
            return null;
        }
    }

    public Point endPoint() {
        return (Point)this.get(this.size() - 1);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LineString) {
            LineString p = (LineString)obj;
            if (p.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (((Point)this.get(i)).equals((Point)p.get(i))) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public int numPoints() {
        return this.size();
    }

    public Point startPoint() {
        return (Point)this.get(0);
    }

    public String toString() {
        int i;
        String s = "( ";
        for (i = 0; i < this.size() - 1; ++i) {
            s = s + ((Point)this.get(i)).toString() + ",";
        }
        s = s + ((Point)this.get(i)).toString();
        return s.concat(")");
    }
}

