/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.Geometry;
import Altibase.jdbc.driver.SQLStates;
import Altibase.jdbc.driver.aTokenizer;
import Altibase.jdbc.driver.ex;
import java.sql.SQLException;

public class Point
implements Geometry {
    static final String mGeometryName = "POINT";
    static final int mGeometrySize = 24;
    static final int mGeometryType = 1;
    static final long serialVersionUID = 1L;
    public double x;
    public double y;

    public Point(double x, double y) {
        this.setLocation(x, y);
    }

    public Point(String s) throws SQLException {
        s = s.trim().toUpperCase();
        if (s.startsWith(mGeometryName)) {
            s = s.substring(mGeometryName.length()).trim();
        }
        aTokenizer t = new aTokenizer(aTokenizer.removePara(s), ' ');
        try {
            this.setLocation(Double.parseDouble(t.getToken(0)), Double.parseDouble(t.getToken(1)));
        }
        catch (NumberFormatException e) {
            ex.exception((short)106, SQLStates.mFixmsg[44]);
        }
    }

    public String asText() {
        return "POINT(" + this.toString() + ')';
    }

    public Object clone() {
        return new Point(this.x, this.y);
    }

    public int compare(Object o1, Object o2) {
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Point) {
            Point p = (Point)obj;
            return this.x == p.x && this.y == p.y;
        }
        return false;
    }

    public byte geometryType() {
        return 1;
    }

    public double getMaxX() {
        return this.x;
    }

    public double getMaxY() {
        return this.y;
    }

    public double getMinX() {
        return this.x;
    }

    public double getMinY() {
        return this.y;
    }

    public int getSize() {
        return 24;
    }

    public void move(double x, double y) {
        this.setLocation(x, y);
    }

    public void setLocation(double X, double Y) {
        this.x = X;
        this.y = Y;
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public int size() {
        return 1;
    }

    public String toString() {
        return " " + this.x + " " + this.y;
    }

    public double X() {
        return this.x;
    }

    public double Y() {
        return this.y;
    }
}

