/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.SQLStates;
import Altibase.jdbc.driver.cm;
import Altibase.jdbc.driver.cmo;
import Altibase.jdbc.driver.ex;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.sql.Timestamp;

public class cmb
implements cm,
cmo,
SQLStates {
    static final byte CMB_TX_END = 0;
    static final byte CMB_TX_LAST = 1;
    static final byte CMB_TX_NEXT = 2;
    static final byte CMB_TX_RECV = 3;
    static short gSessionId = 0;
    ByteBuffer dbb;
    private int pending = 0;
    byte mHeaderVersion = (byte)4;
    byte mNextHeaderType = 0;
    int mPayloadLength = 0;
    int mSequenceNo = 0;
    short mSerialNo = 0;
    byte mModuleID = 0;
    byte mModuleVersion = 1;
    short mSourceSessionID;
    short mTargetSessionID;
    byte op;
    boolean last;

    final boolean isLast() {
        return this.last;
    }

    cmb() {
        short s = gSessionId;
        gSessionId = (short)(s + 1);
        this.mSourceSessionID = s;
        this.mTargetSessionID = 0;
    }

    final ByteBuffer init() throws SQLException {
        this.mPayloadLength = 0;
        this.pending = 0;
        return (ByteBuffer)this.dbb.limit(0);
    }

    final ByteBuffer op(byte operation) throws SQLException {
        this.op = operation;
        return this.dbb.put(this.op);
    }

    final ByteBuffer begin() throws SQLException {
        this.mSerialNo = (short)(this.mSerialNo + 1);
        this.mSequenceNo = 0;
        this.mPayloadLength = 0;
        this.dbb.clear();
        this.dbb.position(16);
        return this.dbb;
    }

    final ByteBuffer next() throws SQLException {
        ++this.mSequenceNo;
        this.mPayloadLength = 0;
        this.dbb.clear();
        this.dbb.position(16);
        return this.dbb;
    }

    final ByteBuffer end() throws SQLException {
        this.mSequenceNo |= Integer.MIN_VALUE;
        return this.flush();
    }

    final ByteBuffer flush() throws SQLException {
        int pos = this.dbb.position();
        this.mPayloadLength = pos - 16;
        this.dbb.position(0);
        this.dbb.put(this.mHeaderVersion);
        this.dbb.put(this.mNextHeaderType);
        this.dbb.putShort((short)this.mPayloadLength);
        this.dbb.putInt(this.mSequenceNo);
        this.dbb.putShort(this.mSerialNo);
        this.dbb.put(this.mModuleID);
        this.dbb.put(this.mModuleVersion);
        this.dbb.putShort(this.mSourceSessionID);
        this.dbb.putShort(this.mTargetSessionID);
        this.dbb.position(pos);
        return (ByteBuffer)this.dbb.flip();
    }

    final ByteBuffer buffer() {
        return this.dbb;
    }

    final ByteBuffer clear() {
        this.mPayloadLength = 0;
        return (ByteBuffer)this.dbb.clear();
    }

    final ByteBuffer compact() {
        return this.dbb.compact();
    }

    final byte get() {
        return this.dbb.get();
    }

    ByteBuffer getBytes(byte[] dst, int offset, int length) {
        return this.dbb.get(dst, offset, length);
    }

    ByteBuffer putBytes(byte[] src, int offset, int length) {
        return this.dbb.put(src, offset, length);
    }

    Byte getByte() {
        return new Byte(this.dbb.get());
    }

    Double getDouble() {
        return new Double(this.dbb.getDouble());
    }

    Float getFloat() {
        return new Float(this.dbb.getFloat());
    }

    final byte getHeaderVersion() {
        return this.mHeaderVersion;
    }

    Integer getInteger() {
        return new Integer(this.dbb.getInt());
    }

    Long getLong() {
        return new Long(this.dbb.getLong());
    }

    final byte getModuleID() {
        return this.mModuleID;
    }

    final byte getModuleVersion() {
        return this.mModuleVersion;
    }

    final byte getNextHeaderType() {
        return this.mNextHeaderType;
    }

    final int getPayloadLength() {
        return this.mPayloadLength;
    }

    final short getSequenceNo() {
        return (short)(this.mSequenceNo >> 0 & Integer.MAX_VALUE);
    }

    final int getSerialNo() {
        return this.mSerialNo;
    }

    Short getShort() {
        return new Short(this.dbb.getShort());
    }

    final short getSourceSessionID() {
        return this.mSourceSessionID;
    }

    final short getTargetSessionID() {
        return this.mTargetSessionID;
    }

    final Timestamp getTimestamp(Timestamp ts) throws SQLException {
        if (ts == null) {
            ts = new Timestamp(0L);
        }
        int sYear = this.dbb.getShort() - 1900;
        int sMonth = this.dbb.get() - 1;
        byte sDay = this.dbb.get();
        byte sHour = this.dbb.get();
        byte sMinute = this.dbb.get();
        byte sSecond = this.dbb.get();
        int sMicroSecond = this.dbb.getInt();
        short sTimeZone = this.dbb.getShort();
        ts.setYear(sYear - 1900);
        ts.setMonth(sMonth - 1);
        ts.setDate(sDay);
        ts.setHours(sHour);
        ts.setMinutes(sMinute);
        ts.setSeconds(sSecond);
        ts.setNanos(sMicroSecond * 1000);
        return ts;
    }

    final int intValue() {
        return this.dbb.getInt();
    }

    final int limit() {
        return this.dbb.limit();
    }

    final ByteBuffer limit(int lim) {
        return (ByteBuffer)this.dbb.limit(lim);
    }

    long longValue() {
        return this.dbb.getLong();
    }

    float floatValue() {
        return Float.intBitsToFloat(this.dbb.getInt());
    }

    double doubleValue() {
        return Double.longBitsToDouble(this.dbb.getLong());
    }

    final int mark(int v) {
        int pos = this.dbb.position() + v;
        this.dbb.mark().position(pos);
        return pos;
    }

    final int parse() throws SQLException {
        int pos = this.dbb.position();
        this.dbb.flip();
        ex.test(this.mHeaderVersion != this.dbb.get(), (short)29, SQLStates.mFixmsg[34]);
        ex.test(this.mNextHeaderType != this.dbb.get(), (short)29, SQLStates.mFixmsg[35]);
        this.mPayloadLength = this.dbb.getShort() >>> 0;
        this.mSequenceNo = this.dbb.getInt();
        this.mSerialNo = this.dbb.getShort();
        this.last = (this.mSequenceNo & Integer.MIN_VALUE) != 0;
        this.mModuleID = this.dbb.get();
        this.mModuleVersion = this.dbb.get();
        this.mSourceSessionID = this.dbb.getShort();
        this.mTargetSessionID = this.dbb.getShort();
        this.dbb.position(pos);
        return this.mPayloadLength;
    }

    final void afterfix() {
        int size = this.mPayloadLength + 16;
        this.pending = this.dbb.limit() - size;
        if (this.pending < 0) {
            this.pending = 0;
        }
        this.dbb.position(16);
        this.dbb.limit(size);
    }

    final int pending() {
        int pend = this.pending;
        if (this.pending > 0) {
            this.dbb.limit(this.dbb.limit() + this.pending);
            this.dbb.compact();
        } else {
            this.dbb.clear();
        }
        this.pending = 0;
        return pend;
    }

    final int position() {
        return this.dbb.position();
    }

    final ByteBuffer position(int pos) {
        return (ByteBuffer)this.dbb.position(pos);
    }

    final boolean put(ByteBuffer aBuffer) {
        int sOffset = aBuffer.position();
        this.mark(7);
        int sLim = aBuffer.limit();
        if (aBuffer.remaining() > this.dbb.remaining()) {
            aBuffer.limit(aBuffer.position() + this.dbb.remaining());
        }
        int sPos = this.dbb.put(aBuffer).position();
        aBuffer.limit(sLim);
        short sSize = (short)(aBuffer.position() - sOffset);
        this.dbb.reset();
        this.putInt(sOffset);
        this.putShort(sSize);
        boolean sNext = aBuffer.remaining() > 0;
        this.putBool(!sNext);
        this.dbb.position(sPos);
        return sNext;
    }

    final ByteBuffer putBool(boolean b) {
        return this.dbb.put(b ? (byte)1 : 0);
    }

    final ByteBuffer putByte(byte b) {
        return this.dbb.put(b);
    }

    final ByteBuffer putDouble(double v) {
        return this.dbb.putDouble(v);
    }

    final ByteBuffer putFloat(float v) {
        return this.dbb.putFloat(v);
    }

    final ByteBuffer putInt(long v) {
        return this.dbb.putInt((int)v);
    }

    final ByteBuffer putInt(int v) {
        return this.dbb.putInt(v);
    }

    final ByteBuffer putLong(long v) {
        return this.dbb.putLong(v);
    }

    final ByteBuffer putShort(short v) {
        return this.dbb.putShort(v);
    }

    final int remaining() {
        return this.dbb.remaining();
    }

    final ByteBuffer reset() {
        return (ByteBuffer)this.dbb.reset();
    }

    final ByteBuffer set(ByteBuffer bb) throws SQLException {
        this.mPayloadLength = 0;
        this.dbb = bb;
        return (ByteBuffer)this.dbb.limit(this.mPayloadLength);
    }

    final void setHeaderVersion(byte headerVersion) {
        this.mHeaderVersion = headerVersion;
    }

    final void setModuleID(byte moduleID) {
        this.mModuleID = moduleID;
    }

    final void setModuleVersion(byte moduleVersion) {
        this.mModuleVersion = moduleVersion;
    }

    final void setNextHeaderType(byte nextHeaderType) {
        this.mNextHeaderType = nextHeaderType;
    }

    short shortValue() {
        return this.dbb.getShort();
    }

    public String toString() {
        int from;
        int size;
        StringBuffer sb = new StringBuffer(this.dbb.capacity() * 2);
        sb.append(this.getClass().getName());
        sb.append("[pos=");
        sb.append(this.dbb.position());
        sb.append(" lim=");
        sb.append(this.dbb.limit());
        sb.append(" cap=");
        sb.append(this.dbb.capacity());
        sb.append("]");
        if (this.mPayloadLength == 0) {
            size = this.position();
            from = 0;
        } else {
            size = this.dbb.limit();
            from = this.position();
        }
        for (int i = from; i < size; ++i) {
            sb.append(cm.hex[this.dbb.get(i) >>> 4 & 0xF]);
            sb.append(cm.hex[this.dbb.get(i) & 0xF]);
            if ((i & 3) != 0 || i <= 0) continue;
            if (i % 40 == 0) {
                sb.append('\n');
                continue;
            }
            sb.append(' ');
        }
        return sb.toString();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

