/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.SQLStates;
import Altibase.jdbc.driver.cmb;
import Altibase.jdbc.driver.cmn;
import Altibase.jdbc.driver.ex;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.sql.SQLException;

class cmnTCP
extends cmn {
    private InetSocketAddress addr;
    private SocketChannel chnl;

    cmnTCP(String host, int port) throws SQLException {
        this.addr = new InetSocketAddress(host, port);
        this.type = 1;
        this.chnl = null;
        ex.test(this.addr.isUnresolved(), (short)24, SQLStates.mFixmsg[36] + host + " name.");
    }

    cmb alloc(cmb cb) throws SQLException {
        if (cb.buffer() == null) {
            cb.set(ByteBuffer.allocateDirect(32768));
        }
        return cb;
    }

    void connect(int timeout) throws SQLException {
        if (!this.isConnected()) {
            try {
                this.chnl = SocketChannel.open();
                this.chnl.configureBlocking(true);
                this.timeout(timeout);
                this.chnl.connect(this.addr);
                this.chnl.finishConnect();
            }
            catch (IOException e) {
                ex.exception((short)24);
            }
        }
    }

    void disconnect() throws SQLException {
        ex.test(!this.isConnected(), (short)26);
        try {
            this.chnl.close();
            this.chnl = null;
        }
        catch (IOException e) {
            this.chnl = null;
        }
    }

    boolean isConnected() {
        return this.chnl != null && this.chnl.isConnected();
    }

    final cmb recv(cmb cb) throws SQLException {
        try {
            long left;
            ByteBuffer bb = cb.buffer();
            long n = 0L;
            for (left = (long)(16 - cb.pending()); left > 0L; left -= n) {
                ex.test(Thread.interrupted(), (short)28, SQLStates.mFixmsg[37]);
                n = this.chnl.read(bb);
                ex.test(n < 0L, (short)29);
            }
            left += (long)cb.parse();
            while (left > 0L) {
                ex.test(Thread.interrupted(), (short)28, SQLStates.mFixmsg[37]);
                bb.limit(16 + cb.mPayloadLength);
                n = this.chnl.read(bb);
                ex.test(n < 0L, (short)105);
                left -= n;
            }
            cb.afterfix();
        }
        catch (NotYetConnectedException e) {
            ex.exception((short)26, e.getMessage());
        }
        catch (IOException e) {
            ex.exception((short)29, e.getMessage());
        }
        return cb;
    }

    final cmb send(cmb cb) throws SQLException {
        try {
            this.chnl.write(cb.buffer());
        }
        catch (NotYetConnectedException e) {
            ex.exception((short)26, e.getMessage());
        }
        catch (IOException e) {
            ex.exception((short)29, e.getMessage());
        }
        return cb;
    }

    int timeout() {
        return this.timeout;
    }

    void timeout(int timeout) throws SQLException {
        super.timeout(timeout);
        if (this.chnl != null) {
            try {
                this.chnl.socket().setSoTimeout(this.timeout * 1000);
                this.chnl.socket().setTcpNoDelay(true);
                this.chnl.socket().setKeepAlive(true);
                this.chnl.socket().setReceiveBufferSize(65536);
                this.chnl.socket().setSendBufferSize(65536);
            }
            catch (SocketException e) {
                ex.exception((short)24, e.getMessage());
            }
        }
    }
}

