/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.springframework.ws.transport.AbstractWebServiceConnection;
import org.springframework.ws.transport.TransportInputStream;
import org.springframework.ws.transport.TransportOutputStream;

public abstract class AbstractSenderConnection
extends AbstractWebServiceConnection {
    private TransportOutputStream requestOutputStream;
    private TransportInputStream responseInputStream;

    protected final TransportOutputStream createTransportOutputStream() throws IOException {
        if (this.requestOutputStream == null) {
            this.requestOutputStream = new RequestTransportOutputStream();
        }
        return this.requestOutputStream;
    }

    protected final TransportInputStream createTransportInputStream() throws IOException {
        if (this.hasResponse()) {
            if (this.responseInputStream == null) {
                this.responseInputStream = new ResponseTransportInputStream();
            }
            return this.responseInputStream;
        }
        return null;
    }

    protected void onClose() throws IOException {
    }

    protected abstract boolean hasResponse() throws IOException;

    protected abstract void addRequestHeader(String var1, String var2) throws IOException;

    protected abstract OutputStream getRequestOutputStream() throws IOException;

    protected abstract Iterator getResponseHeaderNames() throws IOException;

    protected abstract Iterator getResponseHeaders(String var1) throws IOException;

    protected abstract InputStream getResponseInputStream() throws IOException;

    class ResponseTransportInputStream
    extends TransportInputStream {
        ResponseTransportInputStream() {
        }

        protected InputStream createInputStream() throws IOException {
            return AbstractSenderConnection.this.getResponseInputStream();
        }

        public Iterator getHeaderNames() throws IOException {
            return AbstractSenderConnection.this.getResponseHeaderNames();
        }

        public Iterator getHeaders(String name) throws IOException {
            return AbstractSenderConnection.this.getResponseHeaders(name);
        }
    }

    class RequestTransportOutputStream
    extends TransportOutputStream {
        RequestTransportOutputStream() {
        }

        public void addHeader(String name, String value) throws IOException {
            AbstractSenderConnection.this.addRequestHeader(name, value);
        }

        protected OutputStream createOutputStream() throws IOException {
            return AbstractSenderConnection.this.getRequestOutputStream();
        }
    }
}

