/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.multiplex;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.multiplex.AppenderFactory;
import org.apache.log4j.multiplex.MultiplexSelector;
import org.apache.log4j.spi.LoggingEvent;

public abstract class MultiplexSelectorSkeleton
implements MultiplexSelector {
    private AppenderFactory appenderFactory;
    protected Map multiplexedAppenders = Collections.synchronizedMap(new HashMap());

    public void close() {
        Iterator iter = this.multiplexedAppenders.values().iterator();
        while (iter.hasNext()) {
            Appender appender = (Appender)iter.next();
            appender.close();
        }
    }

    public final AppenderFactory getAppenderFactory() {
        return this.appenderFactory;
    }

    public final void setAppenderFactory(AppenderFactory appenderFactory) {
        this.appenderFactory = appenderFactory;
    }

    protected Appender lookupOrCreateAsNeeded(Object key, LoggingEvent e) {
        Appender appender = (Appender)this.multiplexedAppenders.get(key);
        if (appender == null) {
            appender = this.getAppenderFactory().create(e);
            this.multiplexedAppenders.put(key, appender);
        }
        return appender;
    }

    public abstract Appender select(LoggingEvent var1);

    public abstract void activateOptions();
}

