/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.cmmn.trace.manager;

import egovframework.rte.fdl.cmmn.trace.handler.TraceHandler;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.util.PathMatcher;

public abstract class AbsTraceHandleManager {
    protected Log log = LogFactory.getLog(this.getClass());
    @Resource(name="messageSource")
    protected MessageSource messageSource;
    protected String packageName;
    protected String[] patterns;
    protected TraceHandler[] handlers;
    protected PathMatcher pm;

    public void setPatterns(String[] patterns) {
        this.patterns = patterns;
    }

    public void setHandlers(TraceHandler[] handlers) {
        this.handlers = handlers;
    }

    public void setPackageName(String canonicalName) {
        this.packageName = canonicalName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setReqExpMatcher(PathMatcher pm) {
        this.pm = pm;
    }

    public boolean hasReqExpMatcher() {
        return this.enableMatcher();
    }

    public boolean enableMatcher() {
        return this.pm != null;
    }

    public boolean trace(Class clazz, String message) {
        this.log.debug((Object)" DefaultExceptionHandleManager.run() ");
        if (!this.enableMatcher()) {
            return false;
        }
        String[] stringArray = this.patterns;
        int n = this.patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            this.log.debug((Object)("pattern = " + pattern + ", thisPackageName = " + this.packageName));
            this.log.debug((Object)("pm.match(pattern, thisPackageName) =" + this.pm.match(pattern, this.packageName)));
            if (this.pm.match(pattern, this.packageName)) {
                TraceHandler[] traceHandlerArray = this.handlers;
                int n3 = this.handlers.length;
                int n4 = 0;
                while (n4 < n3) {
                    TraceHandler eh = traceHandlerArray[n4];
                    eh.todo(clazz, message);
                    ++n4;
                }
                break;
            }
            ++n2;
        }
        return true;
    }
}

