/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.integration.message.typed;

import egovframework.rte.itl.integration.message.typed.TypedListIterator;
import egovframework.rte.itl.integration.type.ListType;
import egovframework.rte.itl.integration.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedList
implements List<Object> {
    protected final ListType type;
    protected List<Object> inner;

    public TypedList(ListType type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.inner = new ArrayList<Object>();
    }

    public TypedList(ListType type, Collection<? extends Object> collection) {
        this(type);
        if (collection == null) {
            throw new IllegalArgumentException();
        }
        this.addAll(collection);
    }

    public TypedList(ListType type, Object array) {
        this(type);
        if (array == null || !array.getClass().isArray()) {
            throw new IllegalArgumentException();
        }
        this.addAll(CollectionUtils.arrayToList((Object)array));
    }

    public ListType getType() {
        return this.type;
    }

    public Type getElementType() {
        return this.type.getElementType();
    }

    protected Object convertToTypedObject(Object value) {
        return this.getElementType().convertToTypedObject(value);
    }

    protected Collection<Object> convertToTypedObjects(Collection<? extends Object> c) {
        if (c == null) {
            return null;
        }
        ArrayList<Object> newCollection = new ArrayList<Object>();
        for (Object object : c) {
            newCollection.add(this.convertToTypedObject(object));
        }
        return newCollection;
    }

    @Override
    public void add(int index, Object element) {
        this.inner.add(index, this.convertToTypedObject(element));
    }

    @Override
    public boolean add(Object o) {
        return this.inner.add(this.convertToTypedObject(o));
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        return this.inner.addAll(this.convertToTypedObjects(c));
    }

    @Override
    public boolean addAll(int index, Collection<? extends Object> c) {
        return this.inner.addAll(index, this.convertToTypedObjects(c));
    }

    @Override
    public void clear() {
        this.inner.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.inner.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.inner.containsAll(c);
    }

    @Override
    public Object get(int index) {
        return this.inner.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.inner.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.inner.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.inner.lastIndexOf(o);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return new TypedListIterator(this.type, this.inner.listIterator());
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return new TypedListIterator(this.type, this.inner.listIterator(index));
    }

    @Override
    public Object remove(int index) {
        return this.inner.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.inner.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.inner.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.inner.retainAll(c);
    }

    @Override
    public Object set(int index, Object element) {
        return this.inner.set(index, this.convertToTypedObject(element));
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        TypedList subList = new TypedList(this.type);
        subList.inner = this.inner.subList(fromIndex, toIndex);
        return subList;
    }

    @Override
    public Object[] toArray() {
        return this.inner.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.inner.toArray(a);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.inner == null ? 0 : this.inner.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypedList other = (TypedList)obj;
        if (this.inner == null ? other.inner != null : !this.inner.equals(other.inner)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

