package egovframework.rte.cvpl.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import egovframework.rte.cvpl.service.EgovCvplFaqService;
import egovframework.rte.cvpl.service.CvplSearchVO;
import egovframework.rte.cvpl.service.CvplFaqVO;
import egovframework.rte.fdl.cmmn.AbstractServiceImpl;
import egovframework.rte.fdl.idgnr.EgovIdGnrService;

/**
 * @Class Name : EgovCvplFaqServiceImpl.java
 * @Description : CvplFaq Business Implement class
 * @Modification Information @ @ 수정일 수정자 수정내용 @ ------- --------
 *               --------------------------- @ 2009.03.05 천종덕 최초 생성
 * 
 * @author 실행환경 개발팀 천종덕
 * @since 2009.03.05
 * @version 1.0
 * @see Copyright (C) 2009 by MOPAS All right reserved.
 */

@Service("cvplFaqService")
public class EgovCvplFaqServiceImpl extends AbstractServiceImpl implements EgovCvplFaqService {

    @Resource(name = "cvplFaqDAO")
    private CvplFaqDAO cvplFaqDAO;

    /** ID Generation */
    @Resource(name = "egovCvplFaqIdGnr")
    private EgovIdGnrService egovCvplFaqIdGnr;

    /**
     * 글을 등록한다.
     * 
     * @param vo
     *            - 등록할 정보가 담긴 CvplFaqVO
     * @return 등록 결과
     * @exception Exception
     */
    public String insertCvplFaq(CvplFaqVO vo) throws Exception {
        log.debug(vo.toString());

        /** ID Generation Service */
        String id = egovCvplFaqIdGnr.getNextStringId();
        vo.setFaqNo(id);
        log.debug(vo.toString());

        cvplFaqDAO.insertCvplFaq(vo);
        return id;
    }

    /**
     * 글을 수정한다.
     * 
     * @param vo
     *            - 수정할 정보가 담긴 CvplFaqVO
     * @return void형
     * @exception Exception
     */
    public void updateCvplFaq(CvplFaqVO vo) throws Exception {
        cvplFaqDAO.updateCvplFaq(vo);
    }

    /**
     * 글을 삭제한다.
     * 
     * @param vo
     *            - 삭제할 정보가 담긴 CvplFaqVO
     * @return void형
     * @exception Exception
     */
    public void deleteCvplFaq(CvplFaqVO vo) throws Exception {
        cvplFaqDAO.deleteCvplFaq(vo);
    }

    /**
     * 글을 조회한다.
     * 
     * @param vo
     *            - 조회할 정보가 담긴 CvplFaqVO
     * @return 조회한 글
     * @exception Exception
     */
    public CvplFaqVO selectCvplFaq(CvplFaqVO vo) throws Exception {
        CvplFaqVO resultVO = cvplFaqDAO.selectCvplFaq(vo);
        if (resultVO == null)
            throw processException("info.nodata.msg");
        return resultVO;
    }

    /**
     * 글 목록을 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 글 목록
     * @exception Exception
     */
    public List selectCvplFaqList(CvplSearchVO searchVO) throws Exception {
        return cvplFaqDAO.selectCvplFaqList(searchVO);
    }

    /**
     * 글 총 갯수를 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 글 총 갯수
     * @exception
     */
    public int selectCvplFaqListTotCnt(CvplSearchVO searchVO) throws Exception {
        return cvplFaqDAO.selectCvplFaqListTotCnt(searchVO);
    }

    /**
     * 검색어의 자동완성기능을 구현한다.
     * 
     * @param srchPrefix
     *            - 자동완성기능을 사용할 문자
     * @return 검색어리스트
     * @exception Exception
     */
    public List<String> selectSearchKeywordList(String srchPrefix) throws Exception {
        return (List<String>) cvplFaqDAO.selectSearchKeywordList(srchPrefix);
    }

    /**
     * 검색어의 중복을 체크한다.
     * 
     * @param dupSrchKeyword
     *            - 중복을 체크할 검색어
     * @return searchKeyword
     * @exception Exception
     */
    public String checkDupSearchKeywordList(String dupSrchKeyword) throws Exception {
        return (String) cvplFaqDAO.checkDupSearchKeywordList(dupSrchKeyword);
    }

    /**
     * 검색어를 등록한다.
     * 
     * @param searchKeyword
     *            - 등록할 검색어
     * @return searchKeyword
     * @exception Exception
     */
    public void insertSearchKeywordList(String searchKeyword) throws Exception {
        cvplFaqDAO.insertSearchKeywordList(searchKeyword);
    }

    /**
     * 엑셀파일 목록을 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 글 목록
     * @exception Exception
     */
    public List excelDownCvplFaqList(CvplSearchVO searchVO) throws Exception {
        return cvplFaqDAO.excelDownCvplFaqList(searchVO);
    }

    /**
     * BEST FAQ로 셋팅한다.
     * 
     * @param vo
     *            - 셋팅할 정보가 담긴 CvplFaqVO vo
     * @return void형
     * @exception Exception
     */
    public void updateCvplFaqBest(CvplFaqVO vo) throws Exception {
        cvplFaqDAO.updateCvplFaqBest(vo);
    }

    /**
     * BEST FAQ를 등록한다.
     * 
     * @param vo
     *            - 등록할 정보가 담긴 CvplFaqVO vo
     * @return void형
     * @exception Exception
     */
    public void insertBestCvplFaq(CvplFaqVO vo) throws Exception {
        cvplFaqDAO.insertBestCvplFaq(vo);
    }

}
