package egovframework.rte.cvpl.web;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.annotation.Resource;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

import egovframework.rte.cvpl.common.EgovCvplCmmn;
import egovframework.rte.cvpl.common.EgovCvplSessionAuth;
import egovframework.rte.cvpl.service.CvplCmmnCdVO;
import egovframework.rte.cvpl.service.EgovCvplCmmnCdService;
import egovframework.rte.fdl.security.userdetails.util.EgovUserDetailsHelper;
/**
 * @Class Name : EgovCvplMainController.java
 * @Description : EgovCvplMain Controller class
 * @Modification Information
 * @
 * @  수정일         수정자                   수정내용
 * @ -------    --------    ---------------------------
 * @ 2009.02.01    박소윤          최초 생성
 *
 *  @author 실행환경 개발팀 박소윤
 *  @since 2009.02.01
 *  @version 1.0
 *  @see
 *  
 *  Copyright (C) 2009 by MOPAS  All right reserved.
 */

@Controller
public class EgovCvplMainController {
	
	protected Log log = LogFactory.getLog(this.getClass());

    /** egovCvplCmmn */
    @Resource(name="egovCvplCmmn")
    protected EgovCvplCmmn egovCvplCmmn;

	/** Cache  */
	@Resource(name="ehcache")
    Ehcache gCache ;

    /**
	 * Cvpl Login
	 * @param model - ModelMap
	 * @return "/cvpl/EgovCvplLogin"
	 * @exception Exception
	 */
    @RequestMapping(value="/cvpl/egovCvplLogin.do")
    public String actionEgovCvplLogin(ModelMap model)
            throws Exception {
    	
    	/* set Cache common code */
    	egovCvplCmmn.setCacheCmmnCd();
        
        return "/cvpl/EgovCvplLogin";
    } 

    /**
	 * Cvpl Left 메뉴
	 * @param model - ModelMap
	 * @return "/cvpl/EgovCvplLeft"
	 * @exception Exception
	 */
    @RequestMapping(value="/cvpl/egovCvplLeft.do")
    public String actionEgovCvplLeft(ModelMap model)
            throws Exception {
    	
    	/* Session  */
    	EgovCvplSessionAuth egovCvplSessionAuth = (EgovCvplSessionAuth)EgovUserDetailsHelper.getAuthenticatedUser();    	
        model.addAttribute("egovCvplSessionAuth", egovCvplSessionAuth);
        
        return "/cvpl/EgovCvplLeft";
    } 
	
    /**
	 * Cvpl Top 메뉴
	 * @param model - ModelMap
	 * @return "/cvpl/EgovCvplLeft"
	 * @exception Exception
	 */
    @RequestMapping(value="/cvpl/egovCvplTop.do")
    public String actionEgovCvplTop(ModelMap model)
            throws Exception {
    	
    	/* Session  */
    	EgovCvplSessionAuth egovCvplSessionAuth = (EgovCvplSessionAuth)EgovUserDetailsHelper.getAuthenticatedUser();    	
        model.addAttribute("egovCvplSessionAuth", egovCvplSessionAuth);

        return "/cvpl/EgovCvplTop";
    } 

}
