package egovframework.rte.cvpl.web.view;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.web.servlet.view.document.AbstractExcelView;
import egovframework.rte.cvpl.service.CvplCnsltVO;

/**
 * @Class Name : CvplCnsltExcelView.java
 * @Description : CvplCnsltExcelView class
 * @Modification Information
 * @
 * @  수정일         수정자                   수정내용
 * @ -------    --------    ---------------------------
 * @ 2009.03.05    천종덕          최초 생성
 *
 *  @author 실행환경 개발팀 천종덕
 *  @since 2009.03.05
 *  @version 1.0
 *  @see
 *  
 *  Copyright (C) 2009 by MOPAS  All right reserved.
 */
public class CvplCnsltExcelView extends AbstractExcelView {

	/**
	 * 엑셀파일을 만들어 다운로드한다.
	 * @param model - 생성할 정보가 담긴 Map
	 * @return "엑셀파일 다운로드"
	 * @exception Exception
	 */                 
	@Override
	protected void buildExcelDocument(Map model, HSSFWorkbook wb,
            HttpServletRequest req, HttpServletResponse resp) throws Exception {
        HSSFCell cell = null;
        int idx = 0;

        HSSFSheet sheet = wb.createSheet("민원목록");
        //sheet.setDefaultColumnWidth((short) 12);

        // put text in first cell
        cell = getCell(sheet, 0, 0);
        setText(cell, "민원목록");

        // set header information
        idx = 0;
        setText(getCell(sheet, 2, idx++), "민원접수번호");
        setText(getCell(sheet, 2, idx++), "민원제목");
        setText(getCell(sheet, 2, idx++), "민원내용");
        setText(getCell(sheet, 2, idx++), "민원첨부서류1");
        setText(getCell(sheet, 2, idx++), "민원첨부서류2");
        setText(getCell(sheet, 2, idx++), "민원공개여부");
        setText(getCell(sheet, 2, idx++), "민원공개여부명");
        setText(getCell(sheet, 2, idx++), "접수시간");
        setText(getCell(sheet, 2, idx++), "등록자번호");
        setText(getCell(sheet, 2, idx++), "등록자ID");
        setText(getCell(sheet, 2, idx++), "등록자이름");
        setText(getCell(sheet, 2, idx++), "등록자부서");
        setText(getCell(sheet, 2, idx++), "등록자부서명");
        setText(getCell(sheet, 2, idx++), "등록자직책");
        setText(getCell(sheet, 2, idx++), "등록자직책명");
        setText(getCell(sheet, 2, idx++), "답변내용");
        setText(getCell(sheet, 2, idx++), "답변첨부서류1");
        setText(getCell(sheet, 2, idx++), "답변첨부서류2");
        setText(getCell(sheet, 2, idx++), "답변완료시간");
        setText(getCell(sheet, 2, idx++), "답변자번호");
        setText(getCell(sheet, 2, idx++), "답변자ID");
        setText(getCell(sheet, 2, idx++), "답변자이름");
        setText(getCell(sheet, 2, idx++), "답변자부서");
        setText(getCell(sheet, 2, idx++), "답변자부서명");
        setText(getCell(sheet, 2, idx++), "답변자직책");
        setText(getCell(sheet, 2, idx++), "답변자직책명");
        setText(getCell(sheet, 2, idx++), "메일송신여부");
        setText(getCell(sheet, 2, idx++), "행정기관코드");
        setText(getCell(sheet, 2, idx++), "행정기관명");
        setText(getCell(sheet, 2, idx++), "Best 채택여부");

        Map<String, Object> map= (Map<String, Object>) model.get("cvplCnsltMap");
        List<Object> cvplCnsltList = (List<Object>) map.get("cvplCnslt");

        for (int i = 0; i < cvplCnsltList.size(); i++) {
        	Object obj = cvplCnsltList.get(i);
        	CvplCnsltVO cvplCnsltVO = (CvplCnsltVO) obj;
            idx = 0;
    		
            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getCvplNo());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getCvplSj());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getCvplContents());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getCvplAtch1());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getCvplAtch2());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getCvplOthbcCode());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getCvplOthbcCodeNm());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getReceiptTime());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getUserId());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getUserName());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getUserDept());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getUserDeptNm());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getUserRspofc());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getUserRspofcNm());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getAnswerContents());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getAnswerAtch1());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getAnswerAtch2());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getAnswerTime());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getAnswerUserId());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getAnswerUserName());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getAnswerUserDept());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getAnswerUserDeptNm());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getAnswerUserRspofc());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getAnswerUserRspofcNm());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getEmailYn());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getAdmnstmachCode());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getAdmnstmachCodeNm());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplCnsltVO.getBestYn());

        }
    }
}
