<%@ page contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%
 /**
  * @Class Name : egovCvplCnsltRegisterAnswer.java
  * @Description : CvplCnslt Register Answer 화면
  * @Modification Information
  * @
  * @  수정일         수정자                   수정내용
  * @ -------    --------    ---------------------------
  * @ 2009.03.05    천종덕          최초 생성
  *
  *  @author 실행환경 개발팀 천종덕
  *  @since 2009.03.05
  *  @version 1.0
  *  @see
  *  
  *  Copyright (C) 2009 by MOPAS  All right reserved.
  */
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link rel="stylesheet" type="text/css" href="<c:url value='/css/egovframework/egovCvpl.css'/>"/>
<title><spring:message code="pageTitle.egovCvplCnsltRegisterAnswer" /></title>
<script type="text/javascript" src="<c:url value='/js/egovframework/rte/cvpl/multifile.js'/>"></script>
<script type="text/javaScript" language="javascript" defer="defer">
<!--
var multi_selector = new MultiSelector( document.getElementById( 'cvplFileList' ), 2 );
multi_selector.addElement( document.getElementById( 'cvplFileUploader' ) );

function fn_egov_list_cvplcnslt() {
	document.registerForm.action = "<c:url value='/cvpl/egovCvplCnsltList.do'/>";
	document.registerForm.submit();		
}

function fn_egov_add_cvplcnslt() {
	document.registerForm.action = "<c:url value='/cvpl/insertAnswerCvplCnslt.do'/>";
	document.registerForm.submit();	
}

function fn_egov_cancel_cvplcnslt() {
	document.registerForm.reset();
}

function fn_egov_download_file(reqfile) {
	window.open(encodeURI("<c:url value='/cvpl/egovDownloadFile.do?'/>requestedFile=") + reqfile);
}

-->
</script>
</head>
<body>
<!-- Top -->
<jsp:include page="/cvpl/egovCvplTop.do"/>
<!-- //Top -->
<!-- Left -->
<jsp:include page="/cvpl/egovCvplLeft.do"/>
<!-- //Left -->
<!-- Center -->
<div id="content">
	<!-- 타이틀 -->
	<div id="title">
		<ul>
			<li><img src="<c:url value='/images/egovframework/rte/title_dot.gif'/>"> <spring:message code='pageTitle.egovCvplCnsltRegisterAnswer'/> </li>
		</ul>
	</div>
	<!-- // 타이틀 -->
	<form:form commandName="cvplCnsltVO" name="registerForm" enctype="multipart/form-data" method="post">
	<form:hidden path="cvplNo" />
	<div id="table">
		  <table width="100%" border="1" cellpadding="0" cellspacing="0" bordercolor="#D3E2EC" bordercolordark="#FFFFFF" style="BORDER-TOP:#C2D0DB 2px solid; BORDER-LEFT:#ffffff 1px solid; BORDER-RIGHT:#ffffff 1px solid; BORDER-BOTTOM:#C2D0DB 1px solid; border-collapse: collapse;">
				<colgroup>
					<col width="150">
					<col width="">
				</colgroup>
				<tr>
					<td class="tbtd_caption"><spring:message code='title.cvpl.user' /></td>
					<td class="tbtd_content"><c:out value='${cvplCnsltVO.userName}'/></td>
				</tr>
				<tr>
					<td class="tbtd_caption"><spring:message code='title.cvpl.receiptTime' /></td>
					<td class="tbtd_content"><c:out value='${cvplCnsltVO.receiptTime}'/></td>
				</tr>
				<tr>
					<td class="tbtd_caption"><spring:message code='title.cvpl.cvplSj' /></td>
					<td class="tbtd_content"><c:out value='${cvplCnsltVO.cvplSj}'/></td>
				</tr>
				<tr>
					<td class="tbtd_caption"><spring:message code='title.cvpl.cvplOthbcCode' /></td>
					<td class="tbtd_content"><c:out value='${cvplCnsltVO.cvplOthbcCodeNm}'/></td>
				</tr>
				<tr>
					<td class="tbtd_caption"><spring:message code='title.cvpl.cvplContents' /></td>
					<td class="tbtd_content"><form:textarea path="cvplContents" rows="5" cols="58" readonly="readonly" /></td>
				</tr>
				<tr>
					<td class="tbtd_caption"><spring:message code='title.cvpl.cvplAtch1' /></td>
					<td class="tbtd_content">
						<c:if test="${cvplCnsltVO.cvplAtch1 != '' && cvplCnsltVO.cvplAtch1 != null}">
							<c:out value='${cvplCnsltVO.cvplAtch1}'/>
							<a href="javascript:fn_egov_download_file('<c:out value="${cvplCnsltVO.cvplAtch1}"/>')"><img src="<c:url value='/images/egovframework/rte/btn_form_down.gif'/>" border="0" class="top"></a>
						</c:if>
						<c:if test="${cvplCnsltVO.cvplAtch2 != '' && cvplCnsltVO.cvplAtch2 != null}">
							<br/><c:out value='${cvplCnsltVO.cvplAtch2}'/>
							<a href="javascript:fn_egov_download_file('<c:out value="${cvplCnsltVO.cvplAtch2}"/>')"><img src="<c:url value='/images/egovframework/rte/btn_form_down.gif'/>" border="0" class="top"></a>
						</c:if>
					</td>
				</tr>
			</table>
			<table width="100%" border="0" cellspacing="0" cellpadding="0">
			    <tr>
				    <td height="5"></td>
			    </tr>
			</table>
			<table width="100%" border="1" cellpadding="0" cellspacing="0" bordercolor="#EAE8CE" bordercolordark="#FFFFFF" style="BORDER-TOP:#DFDDB7 2px solid; BORDER-LEFT:#ffffff 1px solid; BORDER-RIGHT:#ffffff 1px solid; BORDER-BOTTOM:#DFDDB7 1px solid; border-collapse: collapse;">
				  <colgroup>
					  <col width="150">
					  <col width="">
				  </colgroup>
				  <tr>
					<td class="tbtd_caption_re"><spring:message code='title.cvpl.answerUser' /></td>
					<td class="tbtd_content_re"><form:input path="answerUserName" cssClass="txt" readonly="readonly" /></td>
				  </tr>
				  <tr>
					<td class="tbtd_caption_re"><spring:message code='title.cvpl.answerContents' /></td>
					<td class="tbtd_content_re"><form:textarea path="answerContents" rows="5" cols="58" /></td>
				  </tr>
				  <tr>
					<td class="tbtd_caption_re"><spring:message code='title.cvpl.answerAtch1' /></td>
					<td class="tbtd_content_re"><input name="file_1" id="cvplFileUploader" type="file" size="60" class="txt"/></td>
				  </tr>
				  <tr>
					<td class="tbtd_caption_re"><spring:message code='title.cvpl.answerAtch2' /></td>
					<td class="tbtd_content_re"><div id="cvplFileList"></div></td>
				  </tr>
			</table>
	</div>
	<div id="sysbtn">
		<ul>
		<li><span class="btn_blue_l"><a href="javascript:fn_egov_list_cvplcnslt();"><spring:message code='button.list' /></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li>
		<c:if test="${(egovCvplSessionAuth.isAdmin || egovCvplSessionAuth.isEgov)}">
		<li><span class="btn_blue_l"><a href="javascript:fn_egov_add_cvplcnslt();"><spring:message code='button.insertAnswer' /></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li>
		</c:if>
		<li><span class="btn_blue_l"><a href="javascript:fn_egov_cancel_cvplcnslt();"><spring:message code='button.reset' /></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li></ul>
	</div>
	<!-- 검색조건 유지 -->
	<input type="hidden" name="searchCondition" value="<c:out value='${searchVO.searchCondition}'/>"/>
	<input type="hidden" name="searchKeyword" value="<c:out value='${searchVO.searchKeyword}'/>"/>
	<input type="hidden" name="pageIndex" value="<c:out value='${searchVO.pageIndex}'/>"/>
	</form:form>
</div>
<!-- /Center -->
<!-- Bottom -->
<jsp:include page="/cvpl/EgovCvplBottom.do"/>
<!-- //Bottom -->
</body>
</html>