package egovframework.rte.cvpl.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.annotation.Resource;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import egovframework.rte.cvpl.service.CvplCmmnCdVO;
import egovframework.rte.cvpl.service.EgovCvplCmmnCdService;

/**
 * @Class Name : EgovCvplUserController.java
 * @Description : EgovCvplUser Controller class
 * @Modification Information @ @ 수정일 수정자 수정내용 @ ------- --------
 *               --------------------------- @ 2009.02.01 박소윤 최초 생성
 * 
 * @author 실행환경 개발팀 박소윤
 * @since 2009.02.01
 * @version 1.0
 * @see Copyright (C) 2009 by MOPAS All right reserved.
 */

public class EgovCvplCmmn {

    protected Log log = LogFactory.getLog(this.getClass());

    @Resource(name = "cvplCmmnCdService")
    private EgovCvplCmmnCdService cvplCmmnCdService;

    /** Cache */
    @Resource(name = "ehcache")
    Ehcache gCache;

    /**
     * Common code Cache set
     * 
     * @param model
     *            - ModelMap
     * @return boolean
     * @exception Exception
     */
    public boolean setCacheCmmnCd() throws Exception {
        boolean blResult = false;

        /* common code cache */
        Ehcache cache = gCache.getCacheManager().getCache("cvplCmmCd");

        String chCode = "";
        List cvplCmmnCdList = cvplCmmnCdService.selectCvplCmmnCdList();
        List<CvplCmmnCdVO> mainCdList = new ArrayList<CvplCmmnCdVO>();

        for (Iterator i = cvplCmmnCdList.iterator(); i.hasNext();) {
            CvplCmmnCdVO cvlpCmmnCdVO = (CvplCmmnCdVO) i.next();

            String mainCode = cvlpCmmnCdVO.getMainCode();

            if (i.hasNext()) {
                if (chCode == "" || chCode.equals(mainCode)) {
                    mainCdList.add(cvlpCmmnCdVO);
                } else {
                    cache.put(new Element(chCode, mainCdList));
                    log.debug("chCode >>> " + chCode + " >>> " + mainCdList.size());

                    mainCdList = new ArrayList<CvplCmmnCdVO>();
                    mainCdList.add(cvlpCmmnCdVO);
                }
            } else {
                mainCdList.add(cvlpCmmnCdVO);
                cache.put(new Element(chCode, mainCdList));
                log.debug("chCode >>> " + chCode + " >>> " + mainCdList.size());
            }

            chCode = mainCode;
        }

        return blResult;
    }

    /**
     * 공통코드를 조회한다.
     * 
     * @param key
     *            - 조회할 코드 key
     * @return List<CvplCmmnCdVO>
     * @exception Exception
     */
    public List<CvplCmmnCdVO> getCmmnCd(String key) throws Exception {

        /* common code cache */
        Ehcache cache = gCache.getCacheManager().getCache("cvplCmmCd");
        Element el = cache.get(key);

        log.debug("getCmmnCd Element el >>> " + el);

        if ("".equals(el) || el == null) {
            setCacheCmmnCd();

            cache = gCache.getCacheManager().getCache("cvplCmmCd");
            el = cache.get(key);
        }

        return (List<CvplCmmnCdVO>) el.getValue();
    }

}
