package egovframework.rte.cvpl.service;

import java.util.List;

/**
 * @Class Name : EgovCvplFaqService.java
 * @Description : EgovCvplFaq Business class
 * @Modification Information @ @ 수정일 수정자 수정내용 @ ------- --------
 *               --------------------------- @ 2009.03.05 천종덕 최초 생성
 * 
 * @author 실행환경 개발팀 천종덕
 * @since 2009.03.05
 * @version 1.0
 * @see Copyright (C) 2009 by MOPAS All right reserved.
 */
public interface EgovCvplFaqService {

    /**
     * 글을 등록한다.
     * 
     * @param vo
     *            - 등록할 정보가 담긴 CvplFaqVO
     * @return 등록 결과
     * @exception Exception
     */
    String insertCvplFaq(CvplFaqVO vo) throws Exception;

    /**
     * 글을 수정한다.
     * 
     * @param vo
     *            - 수정할 정보가 담긴 CvplFaqVO
     * @return void형
     * @exception Exception
     */
    void updateCvplFaq(CvplFaqVO vo) throws Exception;

    /**
     * 글을 삭제한다.
     * 
     * @param vo
     *            - 삭제할 정보가 담긴 CvplFaqVO
     * @return void형
     * @exception Exception
     */
    void deleteCvplFaq(CvplFaqVO vo) throws Exception;

    /**
     * 글을 조회한다.
     * 
     * @param vo
     *            - 조회할 정보가 담긴 CvplFaqVO
     * @return 조회한 글
     * @exception Exception
     */
    CvplFaqVO selectCvplFaq(CvplFaqVO vo) throws Exception;

    /**
     * 글 목록을 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 글 목록
     * @exception Exception
     */
    List selectCvplFaqList(CvplSearchVO searchVO) throws Exception;

    /**
     * 글 총 갯수를 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 글 총 갯수
     * @exception
     */
    int selectCvplFaqListTotCnt(CvplSearchVO searchVO) throws Exception;

    /**
     * 검색어의 자동완성기능을 구현한다.
     * 
     * @param srchPrefix
     *            - 자동완성기능을 사용할 문자
     * @return 검색어리스트
     * @exception Exception
     */
    List<String> selectSearchKeywordList(String srchPrefix) throws Exception;

    /**
     * 검색어의 중복을 체크한다.
     * 
     * @param dupSrchKeyword
     *            - 중복을 체크할 검색어
     * @return searchKeyword
     * @exception Exception
     */
    String checkDupSearchKeywordList(String dupSrchKeyword) throws Exception;

    /**
     * 검색어를 등록한다.
     * 
     * @param searchKeyword
     *            - 등록할 검색어
     * @return searchKeyword
     * @exception Exception
     */
    void insertSearchKeywordList(String searchKeyword) throws Exception;

    /**
     * 엑셀파일 목록을 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 글 목록
     * @exception Exception
     */
    List excelDownCvplFaqList(CvplSearchVO searchVO) throws Exception;

    /**
     * BEST FAQ로 셋팅한다.
     * 
     * @param vo
     *            - 셋팅할 정보가 담긴 CvplFaqVO vo
     * @return void형
     * @exception Exception
     */
    void updateCvplFaqBest(CvplFaqVO vo) throws Exception;

    /**
     * BEST FAQ를 등록한다.
     * 
     * @param vo
     *            - 등록할 정보가 담긴 CvplFaqVO vo
     * @return void형
     * @exception Exception
     */
    void insertBestCvplFaq(CvplFaqVO vo) throws Exception;

}
