package egovframework.rte.cvpl.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import egovframework.rte.cvpl.service.EgovCvplCnsltService;
import egovframework.rte.cvpl.service.CvplSearchVO;
import egovframework.rte.cvpl.service.CvplCnsltVO;
import egovframework.rte.cvpl.service.CvplEmailVO;
import egovframework.rte.fdl.cmmn.AbstractServiceImpl;
import egovframework.rte.fdl.idgnr.EgovIdGnrService;

/**
 * @Class Name : EgovCvplCnsltServiceImpl.java
 * @Description : CvplCnslt Business Implement class
 * @Modification Information @ @ 수정일 수정자 수정내용 @ ------- --------
 *               --------------------------- @ 2009.03.05 천종덕 최초 생성
 * 
 * @author 실행환경 개발팀 천종덕
 * @since 2009.03.05
 * @version 1.0
 * @see Copyright (C) 2009 by MOPAS All right reserved.
 */

@Service("cvplCnsltService")
public class EgovCvplCnsltServiceImpl extends AbstractServiceImpl implements EgovCvplCnsltService {

    @Resource(name = "cvplCnsltDAO")
    private CvplCnsltDAO cvplCnsltDAO;

    /** ID Generation */
    @Resource(name = "egovCvplCnsltIdGnr")
    private EgovIdGnrService egovCvplCnsltIdGnr;

    /**
     * 글을 등록한다.
     * 
     * @param vo
     *            - 등록할 정보가 담긴 CvplCnsltVO
     * @return 등록 결과
     * @exception Exception
     */
    public String insertCvplCnslt(CvplCnsltVO vo) throws Exception {
        log.debug(vo.toString());

        /** ID Generation Service */
        String id = egovCvplCnsltIdGnr.getNextStringId();
        vo.setCvplNo(id);
        log.debug(vo.toString());

        cvplCnsltDAO.insertCvplCnslt(vo);
        return id;
    }

    /**
     * 답변을 등록한다.
     * 
     * @param vo
     *            - 등록할 정보가 담긴 CvplCnsltVO
     * @return void형
     * @exception Exception
     */
    public void insertAnswerCvplCnslt(CvplCnsltVO vo) throws Exception {
        cvplCnsltDAO.insertAnswerCvplCnslt(vo);
    }

    /**
     * 글을 수정한다.
     * 
     * @param vo
     *            - 수정할 정보가 담긴 CvplCnsltVO
     * @return void형
     * @exception Exception
     */
    public void updateCvplCnslt(CvplCnsltVO vo) throws Exception {
        cvplCnsltDAO.updateCvplCnslt(vo);
    }

    /**
     * 답변을 수정한다.
     * 
     * @param vo
     *            - 수정할 정보가 담긴 CvplCnsltVO
     * @return void형
     * @exception Exception
     */
    public void updateAnswerCvplCnslt(CvplCnsltVO vo) throws Exception {
        cvplCnsltDAO.updateAnswerCvplCnslt(vo);
    }

    /**
     * 글을 삭제한다.
     * 
     * @param vo
     *            - 삭제할 정보가 담긴 CvplCnsltVO
     * @return void형
     * @exception Exception
     */
    public void deleteCvplCnslt(CvplCnsltVO vo) throws Exception {
        cvplCnsltDAO.deleteCvplCnslt(vo);
    }

    /**
     * 답변을 삭제한다.
     * 
     * @param vo
     *            - 삭제할 정보가 담긴 CvplCnsltVO
     * @return void형
     * @exception Exception
     */
    public void deleteAnswerCvplCnslt(CvplCnsltVO vo) throws Exception {
        cvplCnsltDAO.deleteAnswerCvplCnslt(vo);
    }

    /**
     * 글을 조회한다.
     * 
     * @param vo
     *            - 조회할 정보가 담긴 CvplCnsltVO
     * @return 조회한 글
     * @exception Exception
     */
    public CvplCnsltVO selectCvplCnslt(CvplCnsltVO vo) throws Exception {
        CvplCnsltVO resultVO = cvplCnsltDAO.selectCvplCnslt(vo);
        if (resultVO == null)
            throw processException("info.nodata.msg");
        return resultVO;
    }

    /**
     * 글 목록을 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 글 목록
     * @exception Exception
     */
    public List selectCvplCnsltList(CvplSearchVO searchVO) throws Exception {
        return cvplCnsltDAO.selectCvplCnsltList(searchVO);
    }

    /**
     * 글 총 갯수를 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 글 총 갯수
     * @exception
     */
    public int selectCvplCnsltListTotCnt(CvplSearchVO searchVO) throws Exception {
        return cvplCnsltDAO.selectCvplCnsltListTotCnt(searchVO);
    }

    /**
     * 검색어의 자동완성기능을 구현한다.
     * 
     * @param srchPrefix
     *            - 자동완성기능을 사용할 문자
     * @return 검색어리스트
     * @exception Exception
     */
    public List<String> selectSearchKeywordList(String srchPrefix) throws Exception {
        return (List<String>) cvplCnsltDAO.selectSearchKeywordList(srchPrefix);
    }

    /**
     * 검색어의 중복을 체크한다.
     * 
     * @param dupSrchKeyword
     *            - 중복을 체크할 검색어
     * @return searchKeyword
     * @exception Exception
     */
    public String checkDupSearchKeywordList(String dupSrchKeyword) throws Exception {
        return (String) cvplCnsltDAO.checkDupSearchKeywordList(dupSrchKeyword);
    }

    /**
     * 검색어를 등록한다.
     * 
     * @param searchKeyword
     *            - 등록할 검색어
     * @return searchKeyword
     * @exception Exception
     */
    public void insertSearchKeywordList(String searchKeyword) throws Exception {
        cvplCnsltDAO.insertSearchKeywordList(searchKeyword);
    }

    /**
     * 엑셀파일 목록을 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 글 목록
     * @exception Exception
     */
    public List excelDownCvplCnsltList(CvplSearchVO searchVO) throws Exception {
        return cvplCnsltDAO.excelDownCvplCnsltList(searchVO);
    }

    /**
     * 메일송신 목록을 조회한다.
     * 
     * @param
     * @return 메일송신 목록
     * @exception Exception
     */
    public List<CvplEmailVO> selectCvplEmail() throws Exception {
        return cvplCnsltDAO.selectCvplEmail();
    }

    /**
     * 메일송신 완료를 셋팅한다.
     * 
     * @param vo
     *            - 셋팅할 정보가 담긴 CvplEmailVO
     * @return void형
     * @exception Exception
     */
    public void updateCvplEmailSend(CvplEmailVO vo) throws Exception {
        cvplCnsltDAO.updateCvplEmailSend(vo);
    }

    /**
     * 나의민원 목록을 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 나의민원 목록
     * @exception Exception
     */
    public List selectCvplCnsltMyList(CvplSearchVO searchVO) throws Exception {
        return cvplCnsltDAO.selectCvplCnsltMyList(searchVO);
    }

    /**
     * 나의민원 엑셀파일 목록을 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 나의민원 목록
     * @exception Exception
     */
    public List excelDownCvplCnsltMyList(CvplSearchVO searchVO) throws Exception {
        return cvplCnsltDAO.excelDownCvplCnsltMyList(searchVO);
    }

    /**
     * BEST 민원으로 셋팅한다.
     * 
     * @param vo
     *            - 셋팅할 정보가 담긴 CvplCnsltVO vo
     * @return void형
     * @exception Exception
     */
    public void updateCvplCnsltBest(CvplCnsltVO vo) throws Exception {
        cvplCnsltDAO.updateCvplCnsltBest(vo);
    }

    /**
     * BEST 민원을 등록한다.
     * 
     * @param vo
     *            - 등록할 정보가 담긴 CvplCnsltVO vo
     * @return void형
     * @exception Exception
     */
    public void insertBestCvplCnslt(CvplCnsltVO vo) throws Exception {
        cvplCnsltDAO.insertBestCvplCnslt(vo);
    }

}
