package egovframework.rte.cvpl.web.view;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.web.servlet.view.document.AbstractExcelView;

import egovframework.rte.cvpl.service.CvplUserVO;

public class CvplUserExcelView extends AbstractExcelView {

	@Override
	protected void buildExcelDocument(Map model, HSSFWorkbook wb,
            HttpServletRequest req, HttpServletResponse resp) throws Exception {
        HSSFCell cell = null;
        int idx = 0;

        HSSFSheet sheet = wb.createSheet("사용자목록");
        //sheet.setDefaultColumnWidth((short) 12);

        // put text in first cell
        cell = getCell(sheet, 0, 0);
        setText(cell, "사용자목록");

        // set header information
        idx = 0;
        setText(getCell(sheet, 2, idx++), "번호");
        setText(getCell(sheet, 2, idx++), "아이디");
        setText(getCell(sheet, 2, idx++), "성명");
        setText(getCell(sheet, 2, idx++), "E-Mail");
        setText(getCell(sheet, 2, idx++), "주소");
        setText(getCell(sheet, 2, idx++), "부서코드");
        setText(getCell(sheet, 2, idx++), "부서명");
        setText(getCell(sheet, 2, idx++), "직책코드");
        setText(getCell(sheet, 2, idx++), "직책명");

        Map<String, Object> map= (Map<String, Object>) model.get("cvplUserMap");
        List<Object> cvplUserList = (List<Object>) map.get("cvplUser");
        
        for (int i = 0; i < cvplUserList.size(); i++) {
        	Object obj = cvplUserList.get(i);
        	CvplUserVO cvplUserVO = (CvplUserVO) obj;
            idx = 0;
    		
            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplUserVO.getUserId());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplUserVO.getUserName());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplUserVO.getEmail());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplUserVO.getAddress());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplUserVO.getDeptCode());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplUserVO.getDeptNm());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplUserVO.getRspofcCode());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplUserVO.getRspofcNm());

        }
    }
}
