<%@ page contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="validator" uri="http://www.springmodules.org/tags/commons-validator" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ page import="egovframework.rte.cvpl.service.CvplUserVO" %>
<%
 /**
  * Class Name : p_checkCvplUserIdDplc.jsp
  * Description : Civil Appeal Sample 사용자 ID 중복 check 화면
  * Modification Information
  * 
  *   수정일         수정자                   수정내용
  *  -------    --------    ---------------------------
  *  2009.02.01   박소윤         최초 생성
  *
  * author 실행환경 개발팀 박소윤
  * since 2009.02.01
  *  
  * Copyright (C) 2009 by MOPAS  All right reserved.
  */
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link rel="stylesheet" type="text/css" href="<c:url value='/css/egovframework/egovCvpl.css'/>"/>
<c:set var="registerFlag" value="${blDplc == true ? 'TRUE' : 'FALSE'}"/>
<c:set var="userIdFlag" value="${empty cvplUserVO.userId ? 'NULL' : 'NOTNULL'}"/>
<title><spring:message code="pageTitle.egovCvplUserIdDupl" /></title>

<!--For Commons Validator Client Side-->
<script type="text/javascript" src="<c:url value="/cmmn/validator.js"/>"></script>
<validator:javascript formName="cvplUserVO" staticJavascript="false" xhtml="true" cdata="false"/>

<script type="text/javaScript" language="javascript" defer="defer" src="<c:url value='/js/egovframework/rte/cvpl/cvpluser_cmmn.js'/>"></script>
<script type="text/javaScript" language="javascript" defer="defer">
<!--
function fn_egov_check_dplc() {
	frm = document.checkForm;
    /* Form validation */
    if(FormValidation(frm) != false) {
        
    	frm.action="<c:url value='/cvpl/checkCvplUserIdDplc.do'/>";
    	frm.submit();
    } 
}

function fn_egov_userId_use() {

    if(opener) {
    	opener.document.registerForm.userIdCheck.value = "1";
    	opener.document.registerForm.userId.value = "<c:out value='${cvplUserVO.userId}'/>";
    	
    }
    
    window.close();
}

-->
</script>
</head>
<body>
<form:form commandName="cvplUserVO" name="checkForm">
<table width="350" height="200" border="0" cellpadding="0" cellspacing="0">
  <tr>
    <td align="center" valign="top" background="<c:url value='/images/egovframework/rte/id_double_bg.jpg'/>"><table width="100%" border="0" cellspacing="5" cellpadding="0">
      <tr>
        <td height="30" style="font-size:12px; color:#FFFFFF; font-weight:bold;"><spring:message code="button.checkUserIdDupl"/></td>
      </tr>

		<c:if test="${registerFlag == 'TRUE'}">
		<tr>
			<td height="50" align="center" style="color:#000000;"><span style="height:20px; border-bottom:1px dashed #FF0000;">[<b><c:out value='${cvplUserVO.userId}'/></b>]<spring:message code="info.cvpl.userIdDplc.msg"/></span> </td>
		</tr>
		</c:if>
		<c:if test="${registerFlag == 'FALSE'}">
		<tr>
			<td height="30" align="center"><spring:message code="${userIdFlag == 'NULL' ? 'info.cvpl.userIdBlank.msg' : 'info.cvpl.userIdUse.msg'}"/></td>
		</tr>
		</c:if>

      <tr>
        <td align="center"><table border="0" cellspacing="5" cellpadding="0">
          <tr>
            <td><spring:message code="cvplUserVO.userId"/></td>
            <td>
              <form:input path="userId" cssClass="txt" size="18" />&nbsp;<form:errors path="userId" /></td>
            <td><a href="javascript:fn_egov_check_dplc();"><img src="<c:url value='/images/egovframework/rte/'/><spring:message code='image.confirm' />" border="0" class="top"></a></td>
          </tr>
		  </table>
		  <table border="0" cellspacing="5" cellpadding="0">
            <tr>
              <td>
				  <c:if test="${registerFlag == 'FALSE' && userIdFlag == 'NOTNULL'}">
				  <a href="javascript:fn_egov_userId_use();"><img src="<c:url value='/images/egovframework/rte/'/><spring:message code='image.use' />" border="0" class="top"></a>
				  </c:if>
			      <a href="javascript:window.close();"><img src="<c:url value='/images/egovframework/rte/'/><spring:message code='image.closed' />" border="0" class="top"></a></td>
            </tr>
          </table></td>
      </tr>
    </table></td>
  </tr>
</table>
</form:form>
</body>
</html>

