package egovframework.rte.cvpl.util;

import java.util.HashMap;
import java.util.Map;

import javax.annotation.Resource;

import egovframework.rte.cvpl.service.CvplCnsltVO;
import egovframework.rte.itl.integration.EgovIntegrationMessage;
import egovframework.rte.itl.integration.EgovIntegrationService;
import egovframework.rte.itl.webservice.EgovWebServiceContext;

public class EgovWebServiceClientRegisterCvpl {

    @Resource(name = "egovWebServiceContext")
    private EgovWebServiceContext context;

    private String integrationId;

    /**
     * @param context
     *            the context to set
     */
    public void setContext(EgovWebServiceContext context) {
        this.context = context;
    }

    /**
     * @param integrationId
     *            the integrationId to set
     */
    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public boolean registerCvpl(final CvplCnsltVO vo) {
        EgovIntegrationService service = context.getService(integrationId);

        EgovIntegrationMessage requestMessage = service.createRequestMessage();
        Map<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("cvplNo", vo.getCvplNo());
        requestBody.put("cvplSj", vo.getCvplSj());
        requestBody.put("cvplContents", vo.getCvplContents());
        requestBody.put("cvplAtch1", vo.getCvplAtch1());
        requestBody.put("cvplAtch2", vo.getCvplAtch2());
        requestBody.put("cvplOthbcCode", vo.getCvplOthbcCode());
        requestBody.put("receiptTime", vo.getOrgReceiptTime());
        requestBody.put("userId", vo.getUserId());
        requestBody.put("answerContents", vo.getAnswerContents());
        requestBody.put("answerAtch1", vo.getAnswerAtch1());
        requestBody.put("answerAtch2", vo.getAnswerAtch2());
        requestBody.put("answerTime", vo.getOrgAnswerTime());
        requestBody.put("answerUserId", vo.getAnswerUserId());
        requestBody.put("emailYn", vo.getEmailYn());
        requestBody.put("admnstmachCode", vo.getAdmnstmachCode());
        requestBody.put("bestYn", vo.getBestYn());
        requestMessage.setBody(requestBody);

        EgovIntegrationMessage responseMessage = service.sendSync(requestMessage);

        return (Boolean) responseMessage.getBody().get("result");
    }
}
