<%@ page contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%
 /**
  * @Class Name : egovCvplFaqView.java
  * @Description : CvplFaq view 화면
  * @Modification Information
  * @
  * @  수정일         수정자                   수정내용
  * @ -------    --------    ---------------------------
  * @ 2009.03.05    천종덕          최초 생성
  *
  *  @author 실행환경 개발팀 천종덕
  *  @since 2009.03.05
  *  @version 1.0
  *  @see
  *  
  *  Copyright (C) 2009 by MOPAS  All right reserved.
  */
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link rel="stylesheet" type="text/css" href="<c:url value='/css/egovframework/egovCvpl.css'/>"/>
<title><spring:message code="pageTitle.egovCvplFaqView" /></title>
<script type="text/javaScript" language="javascript" defer="defer">
<!--
function fn_egov_list_cvplfaq() {
   	document.detailForm.action = "<c:url value='/cvpl/egovCvplFaqList.do'/>";
   	document.detailForm.submit();		
}

function fn_egov_saveview_cvplfaq() {
   	document.detailForm.action = "<c:url value='/cvpl/updateCvplFaqView.do'/>";
   	document.detailForm.submit();		
}

function fn_egov_delete_cvplfaq() {
   	document.detailForm.action = "<c:url value='/cvpl/deleteCvplFaq.do'/>";
   	document.detailForm.submit();		
}

function fn_egov_set_best() {
   	document.detailForm.action = "<c:url value='/cvpl/updateCvplFaqBest.do'/>";
   	document.detailForm.submit();		
}

function fn_egov_download_file(reqfile) {
	window.open(encodeURI("<c:url value='/cvpl/egovDownloadFile.do?'/>requestedFile=") + reqfile);
}

-->
</script>
</head>
<body>
<!-- Top -->
<jsp:include page="/cvpl/egovCvplTop.do"/>
<!-- //Top -->
<!-- Left -->
<jsp:include page="/cvpl/egovCvplLeft.do"/>
<!-- //Left -->
<!-- Center -->
<div id="content">
	<!-- 타이틀 -->
	<div id="title">
		<ul>
			<li><img src="<c:url value='/images/egovframework/rte/title_dot.gif'/>"> <spring:message code='pageTitle.egovCvplFaqView'/></li>
		</ul>
	</div>
	<!-- // 타이틀 -->
	<form:form commandName="cvplFaqVO" name="detailForm" method="post">
    <form:hidden path="faqNo" />
    <input name="selectedId" type="hidden" value="<c:out value='${cvplFaqVO.faqNo}'/>"/>
	
	<div id="table">
		  <table width="100%" border="1" cellpadding="0" cellspacing="0" bordercolor="#D3E2EC" bordercolordark="#FFFFFF" style="BORDER-TOP:#C2D0DB 2px solid; BORDER-LEFT:#ffffff 1px solid; BORDER-RIGHT:#ffffff 1px solid; BORDER-BOTTOM:#C2D0DB 1px solid; border-collapse: collapse;">
				<colgroup>
						<col width="150">
						<col width="">
				</colgroup>
			  <tr>
				<td class="tbtd_caption"><spring:message code='title.faq.user' /></td>
				<td class="tbtd_content"><c:out value='${cvplFaqVO.userName}'/></td>
			  </tr>
			  <tr>
				<td class="tbtd_caption"><spring:message code='title.faq.registTime' /></td>
				<td class="tbtd_content"><c:out value='${cvplFaqVO.registTime}'/></td>
				</tr>
			  <tr>
				<td class="tbtd_caption"><spring:message code='title.faq.faqSj' /></td>
				<td class="tbtd_content"><c:out value='${cvplFaqVO.faqSj}'/></td>
			  </tr>
			  <tr>
				<td class="tbtd_caption"><spring:message code='title.faq.faqContents' /></td>
				<td class="tbtd_content"><form:textarea path="faqContents" rows="5" cols="58" readonly="readonly" /></td>
				</tr>
			  <tr>
				<td class="tbtd_caption"><spring:message code='title.faq.faqAtch1' /></td>
				<td class="tbtd_content">
					<c:if test="${cvplFaqVO.faqAtch1 != '' && cvplFaqVO.faqAtch1 != null}">
		        		<c:out value='${cvplFaqVO.faqAtch1}'/>
						<a href="javascript:fn_egov_download_file('<c:out value="${cvplFaqVO.faqAtch1}"/>')"><img src="<c:url value='/images/egovframework/rte/btn_form_down.gif'/>" border="0" class="top"></a>
					</c:if>
					<c:if test="${cvplFaqVO.faqAtch2 != '' && cvplFaqVO.faqAtch2 != null}">
						<br/><c:out value='${cvplFaqVO.faqAtch2}'/>
						<a href="javascript:fn_egov_download_file('<c:out value="${cvplFaqVO.faqAtch2}"/>')"><img src="<c:url value='/images/egovframework/rte/btn_form_down.gif'/>" border="0" class="top"></a>
					</c:if>
				</td>
			  </tr>
		  </table>
    </div>
	<div id="sysbtn">
		<ul>
		<c:if test="${cvplFaqVO.bestYn == '0' && egovCvplSessionAuth.isAdmin}">
		<li><span class="btn_blue_l"><a href="javascript:fn_egov_set_best();"><spring:message code='button.bestFaq' /></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li>
		</c:if>

		<li><span class="btn_blue_l"><a href="javascript:fn_egov_list_cvplfaq();"><spring:message code='button.list' /></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li>

		<c:if test="${cvplFaqVO.userId  == egovCvplSessionAuth.userId && (egovCvplSessionAuth.isAdmin || egovCvplSessionAuth.isEgov)}">
		<li><span class="btn_blue_l"><a href="javascript:fn_egov_saveview_cvplfaq();"><spring:message code='button.update' /></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li>
		<li><span class="btn_blue_l"><a href="javascript:fn_egov_delete_cvplfaq();"><spring:message code='button.delete' /></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li>
		</c:if>
		</ul>
	</div>
	<!-- 검색조건 유지 -->
	<input type="hidden" name="searchCondition" value="<c:out value='${searchVO.searchCondition}'/>"/>
	<input type="hidden" name="searchKeyword" value="<c:out value='${searchVO.searchKeyword}'/>"/>
	<input type="hidden" name="pageIndex" value="<c:out value='${searchVO.pageIndex}'/>"/>
	</form:form>
</div>
<!-- /Center -->
<!-- Bottom -->
<jsp:include page="/cvpl/EgovCvplBottom.do"/>
<!-- //Bottom -->
</body>
</html>
