/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.filter;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.archiver.AbstractArchiveFinalizer;
import org.codehaus.plexus.archiver.ArchiveFileFilter;
import org.codehaus.plexus.archiver.ArchiveFilterException;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ComponentsXmlArchiverFileFilter
extends AbstractArchiveFinalizer
implements ArchiveFileFilter {
    protected Map components;
    private boolean excludeOverride = false;
    public static final String COMPONENTS_XML_PATH = "META-INF/plexus/components.xml";

    public boolean include(InputStream dataStream, String entryName) throws ArchiveFilterException {
        if (this.excludeOverride) {
            return true;
        }
        String entry = entryName;
        if (entry.startsWith("/")) {
            entry = entry.substring(1);
        }
        if (COMPONENTS_XML_PATH.equals(entry)) {
            try {
                this.addComponentsXml(new InputStreamReader(dataStream));
            }
            catch (XmlPullParserException e) {
                throw new ArchiveFilterException("Error reading components from stream: " + e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new ArchiveFilterException("Error reading components from stream: " + e.getMessage(), (Throwable)e);
            }
            return false;
        }
        return true;
    }

    protected void addComponentsXml(Reader componentsReader) throws XmlPullParserException, IOException {
        Xpp3Dom newDom = Xpp3DomBuilder.build((Reader)componentsReader);
        if (newDom != null) {
            newDom = newDom.getChild("components");
        }
        if (newDom != null) {
            Xpp3Dom[] children = newDom.getChildren();
            for (int i = 0; i < children.length; ++i) {
                Xpp3Dom component = children[i];
                if (this.components == null) {
                    this.components = new LinkedHashMap();
                }
                String role = component.getChild("role").getValue();
                Xpp3Dom child = component.getChild("role-hint");
                String roleHint = child != null ? child.getValue() : "";
                this.components.put(role + roleHint, component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToArchive(Archiver archiver) throws IOException, ArchiverException {
        if (this.components != null) {
            File f = File.createTempFile("maven-assembly-plugin", "tmp");
            f.deleteOnExit();
            FileWriter fileWriter = new FileWriter(f);
            try {
                Xpp3Dom dom = new Xpp3Dom("component-set");
                Xpp3Dom componentDom = new Xpp3Dom("components");
                dom.addChild(componentDom);
                Iterator i = this.components.values().iterator();
                while (i.hasNext()) {
                    Xpp3Dom component = (Xpp3Dom)i.next();
                    componentDom.addChild(component);
                }
                Xpp3DomWriter.write((Writer)fileWriter, (Xpp3Dom)dom);
            }
            finally {
                IOUtil.close((Writer)fileWriter);
            }
            this.excludeOverride = true;
            archiver.addFile(f, COMPONENTS_XML_PATH);
            this.excludeOverride = false;
        }
    }

    public void finalizeArchiveCreation(Archiver archiver) throws ArchiverException {
        try {
            this.addToArchive(archiver);
        }
        catch (IOException e) {
            throw new ArchiverException("Error finalizing component-set for archive. Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    public List getVirtualFiles() {
        if (this.components != null && !this.components.isEmpty()) {
            return Collections.singletonList(COMPONENTS_XML_PATH);
        }
        return null;
    }
}

