/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.format;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.model.FileSet;
import org.apache.maven.plugin.assembly.utils.AssemblyFileUtils;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public class FileSetFormatter {
    private final AssemblerConfigurationSource configSource;
    private final Logger logger;

    public FileSetFormatter(AssemblerConfigurationSource configSource, Logger logger) {
        this.configSource = configSource;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File formatFileSetForAssembly(File archiveBaseDir, FileSet set) throws AssemblyFormattingException, IOException {
        File formattedDir;
        block4: {
            formattedDir = archiveBaseDir;
            String lineEndingHint = set.getLineEnding();
            String lineEnding = AssemblyFileUtils.getLineEndingCharacters(lineEndingHint);
            if (lineEnding == null) break block4;
            org.apache.maven.shared.model.fileset.FileSet fileSet = new org.apache.maven.shared.model.fileset.FileSet();
            fileSet.setLineEnding(lineEnding);
            fileSet.setDirectory(set.getDirectory());
            fileSet.setIncludes(set.getIncludes());
            formattedDir = FileUtils.createTempFile((String)"fileSetFormatter.", (String)".tmp", (File)this.configSource.getTemporaryRootDirectory());
            formattedDir.delete();
            formattedDir.mkdirs();
            fileSet.setExcludes(set.getExcludes());
            fileSet.setUseDefaultExcludes(true);
            FileSetManager fsm = new FileSetManager(this.logger);
            String[] files = fsm.getIncludedFiles(fileSet);
            if (files == null || files.length == 0) {
                this.logger.info("No files selected for line-ending conversion. Skipping: " + fileSet.getDirectory());
                formattedDir.delete();
                return archiveBaseDir;
            }
            for (int i = 0; i < files.length; ++i) {
                String file = files[i];
                File targetFile = new File(formattedDir, file);
                targetFile.getParentFile().mkdirs();
                File sourceFile = new File(archiveBaseDir, file);
                BufferedReader sourceReader = null;
                try {
                    sourceReader = new BufferedReader(new FileReader(sourceFile));
                    AssemblyFileUtils.convertLineEndings(sourceReader, targetFile, lineEnding);
                }
                catch (Throwable throwable) {
                    IOUtil.close(sourceReader);
                    throw throwable;
                }
                IOUtil.close((Reader)sourceReader);
            }
        }
        return formattedDir;
    }
}

