/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.resource.loader;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.resource.loader.AbstractResourceLoader;
import org.codehaus.plexus.resource.loader.JarHolder;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;

public class JarResourceLoader
extends AbstractResourceLoader {
    public static final String ID = "jar";
    private Map entryDirectory = new HashMap(559);
    private Map jarfiles = new HashMap(89);

    public void initialize() throws InitializationException {
        if (this.paths != null) {
            for (int i = 0; i < this.paths.size(); ++i) {
                this.loadJar((String)this.paths.get(i));
            }
        }
    }

    private void loadJar(String path) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("JarResourceLoader : trying to load \"" + path + "\"");
        }
        if (path == null) {
            this.getLogger().error("JarResourceLoader : can not load JAR - JAR path is null");
        }
        if (!path.startsWith("jar:")) {
            this.getLogger().error("JarResourceLoader : JAR path must start with jar: -> see java.net.JarURLConnection for information");
        }
        if (!path.endsWith("!/")) {
            path = path + "!/";
        }
        this.closeJar(path);
        JarHolder temp = new JarHolder(path);
        this.addEntries(temp.getEntries());
        this.jarfiles.put(temp.getUrlPath(), temp);
    }

    private void closeJar(String path) {
        if (this.jarfiles.containsKey(path)) {
            JarHolder theJar = (JarHolder)this.jarfiles.get(path);
            theJar.close();
        }
    }

    private void addEntries(Hashtable entries) {
        this.entryDirectory.putAll(entries);
    }

    public InputStream getResourceAsInputStream(String source) throws ResourceNotFoundException {
        String jarurl;
        InputStream results = null;
        if (source == null || source.length() == 0) {
            throw new ResourceNotFoundException("Need to have a resource!");
        }
        if (source == null || source.length() == 0) {
            String msg = "JAR resource error : argument " + source + " contains .. and may be trying to access " + "content outside of template root.  Rejected.";
            this.getLogger().error("JarResourceLoader : " + msg);
            throw new ResourceNotFoundException(msg);
        }
        if (source.startsWith("/")) {
            source = source.substring(1);
        }
        if (this.entryDirectory.containsKey(source) && this.jarfiles.containsKey(jarurl = (String)this.entryDirectory.get(source))) {
            JarHolder holder = (JarHolder)this.jarfiles.get(jarurl);
            results = holder.getResource(source);
            return results;
        }
        throw new ResourceNotFoundException("JarResourceLoader Error: cannot find resource " + source);
    }
}

