/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.resource.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.codehaus.plexus.resource.loader.AbstractResourceLoader;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;

public class URLResourceLoader
extends AbstractResourceLoader {
    protected HashMap templateRoots = new HashMap();

    public InputStream getResourceAsInputStream(String name) throws ResourceNotFoundException {
        if (name == null || name.length() == 0) {
            throw new ResourceNotFoundException("URLResourceLoader : No template name provided");
        }
        InputStream inputStream = null;
        Throwable exception = null;
        Iterator i = this.paths.iterator();
        while (i.hasNext()) {
            String path = (String)i.next();
            try {
                URL u = new URL(path + name);
                inputStream = u.openStream();
                if (inputStream == null) continue;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("URLResourceLoader: Found '" + name + "' at '" + path + "'");
                }
                this.templateRoots.put(name, path);
                break;
            }
            catch (IOException ioe) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("URLResourceLoader: Exception when looking for '" + name + "' at '" + path + "'", (Throwable)ioe);
                }
                if (exception != null) continue;
                exception = ioe;
            }
        }
        if (inputStream == null) {
            String msg = exception == null ? "URLResourceLoader : Resource '" + name + "' not found." : exception.getMessage();
            throw new ResourceNotFoundException(msg);
        }
        return inputStream;
    }
}

