/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.interpolation;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.Interpolator;

public class InterpolatorFilterReader
extends FilterReader {
    private Interpolator interpolator;
    private String replaceData = null;
    private int replaceIndex = -1;
    private int previousIndex = -1;
    public static final String DEFAULT_BEGIN_TOKEN = "${";
    public static final String DEFAULT_END_TOKEN = "}";
    private String beginToken;
    private String endToken;

    public InterpolatorFilterReader(Reader in, Interpolator interpolator) {
        this(in, interpolator, DEFAULT_BEGIN_TOKEN, DEFAULT_END_TOKEN);
    }

    public InterpolatorFilterReader(Reader in, Interpolator interpolator, String beginToken, String endToken) {
        super(in);
        this.interpolator = interpolator;
        this.beginToken = beginToken;
        this.endToken = endToken;
    }

    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        for (long i = 0L; i < n; ++i) {
            if (this.read() != -1) continue;
            return i;
        }
        return n;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int ch = this.read();
            if (ch == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            cbuf[off + i] = (char)ch;
        }
        return len;
    }

    public int read() throws IOException {
        if (this.replaceIndex != -1 && this.replaceIndex < this.replaceData.length()) {
            char ch = this.replaceData.charAt(this.replaceIndex++);
            if (this.replaceIndex >= this.replaceData.length()) {
                this.replaceIndex = -1;
            }
            return ch;
        }
        int ch = -1;
        ch = this.previousIndex != -1 && this.previousIndex < this.endToken.length() ? this.endToken.charAt(this.previousIndex++) : this.in.read();
        if (ch == this.beginToken.charAt(0)) {
            String value;
            StringBuffer key = new StringBuffer();
            key.append((char)ch);
            int beginTokenMatchPos = 1;
            while ((ch = this.previousIndex != -1 && this.previousIndex < this.endToken.length() ? (int)this.endToken.charAt(this.previousIndex++) : this.in.read()) != -1) {
                key.append((char)ch);
                if (beginTokenMatchPos < this.beginToken.length() && ch != this.beginToken.charAt(beginTokenMatchPos++)) {
                    ch = -1;
                    break;
                }
                if (ch != this.endToken.charAt(0)) continue;
            }
            if (ch != -1 && this.endToken.length() > 1) {
                int endTokenMatchPos = 1;
                while ((ch = this.previousIndex != -1 && this.previousIndex < this.endToken.length() ? (int)this.endToken.charAt(this.previousIndex++) : this.in.read()) != -1) {
                    key.append((char)ch);
                    if (ch != this.endToken.charAt(endTokenMatchPos++)) {
                        ch = -1;
                        break;
                    }
                    if (endTokenMatchPos < this.endToken.length()) continue;
                }
            }
            if (ch == -1) {
                this.replaceData = key.toString();
                this.replaceIndex = 1;
                return this.replaceData.charAt(0);
            }
            try {
                value = this.interpolator.interpolate(key.toString(), "");
            }
            catch (InterpolationException e) {
                IllegalArgumentException error = new IllegalArgumentException(e.getMessage());
                error.initCause(e);
                throw error;
            }
            if (value != null) {
                if (value.length() != 0) {
                    this.replaceData = value;
                    this.replaceIndex = 0;
                }
                return this.read();
            }
            this.previousIndex = 0;
            this.replaceData = key.substring(0, key.length() - this.endToken.length());
            this.replaceIndex = 0;
            return this.beginToken.charAt(0);
        }
        return ch;
    }
}

