/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.interpolation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.interpolation.ValueSource;

public class RegexBasedInterpolator {
    private List valueSources;

    public RegexBasedInterpolator() {
        this.valueSources = new ArrayList();
    }

    public RegexBasedInterpolator(List valueSources) {
        this.valueSources = new ArrayList(valueSources);
    }

    public void addValueSource(ValueSource valueSource) {
        this.valueSources.add(valueSource);
    }

    public void removeValuesSource(ValueSource valueSource) {
        this.valueSources.remove(valueSource);
    }

    public String interpolate(String input, String thisPrefixPattern) {
        String result = input;
        Pattern expressionPattern = Pattern.compile("\\$\\{(" + thisPrefixPattern + ")?([^}]+)\\}");
        Matcher matcher = expressionPattern.matcher(result);
        while (matcher.find()) {
            String wholeExpr = matcher.group(0);
            String realExpr = matcher.group(2);
            if (realExpr.startsWith(".")) {
                realExpr = realExpr.substring(1);
            }
            Object value = null;
            Iterator it = this.valueSources.iterator();
            while (it.hasNext() && value == null) {
                ValueSource vs = (ValueSource)it.next();
                value = vs.getValue(realExpr);
            }
            if (wholeExpr.equals(value)) {
                throw new IllegalArgumentException("Expression: '" + wholeExpr + "' references itself.");
            }
            if (value == null) continue;
            result = StringUtils.replace((String)result, (String)wholeExpr, (String)String.valueOf(value));
            matcher.reset(result);
        }
        return result;
    }
}

