/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.repository;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.shared.artifact.filter.PatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.ScopeArtifactFilter;
import org.apache.maven.shared.repository.RepositoryAssembler;
import org.apache.maven.shared.repository.RepositoryAssemblyException;
import org.apache.maven.shared.repository.RepositoryBuilderConfigSource;
import org.apache.maven.shared.repository.model.GroupVersionAlignment;
import org.apache.maven.shared.repository.model.RepositoryInfo;
import org.apache.maven.shared.repository.utils.DigestUtils;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public class DefaultRepositoryAssembler
extends AbstractLogEnabled
implements RepositoryAssembler {
    protected static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    protected static final String UTC_TIMESTAMP_PATTERN = "yyyyMMddHHmmss";
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    protected ArtifactRepositoryLayout repositoryLayout;
    protected ArtifactRepositoryFactory artifactRepositoryFactory;
    protected ArtifactMetadataSource metadataSource;
    protected MavenProjectBuilder projectBuilder;
    static /* synthetic */ Class class$org$apache$maven$project$DefaultMavenProjectBuilder;

    public void buildRemoteRepository(File repositoryDirectory, RepositoryInfo repository, RepositoryBuilderConfigSource configSource) throws RepositoryAssemblyException {
        MavenProject project = configSource.getProject();
        ArtifactRepository localRepository = configSource.getLocalRepository();
        Map groupVersionAlignments = this.createGroupVersionAlignments(repository.getGroupVersionAlignments());
        ArtifactRepository targetRepository = this.createLocalRepository(repositoryDirectory);
        ArtifactResolutionResult result = null;
        Set dependencyArtifacts = project.getDependencyArtifacts();
        if (dependencyArtifacts == null) {
            Logger logger = this.getLogger();
            if (logger.isDebugEnabled()) {
                logger.debug("dependency-artifact set for project: " + project.getId() + " is null. Skipping repository processing.");
            }
            return;
        }
        try {
            result = this.artifactResolver.resolveTransitively(dependencyArtifacts, project.getArtifact(), project.getRemoteArtifactRepositories(), localRepository, this.metadataSource);
        }
        catch (ArtifactResolutionException e) {
            throw new RepositoryAssemblyException("Error resolving artifacts: " + e.getMessage(), e);
        }
        catch (ArtifactNotFoundException e) {
            throw new RepositoryAssemblyException("Error resolving artifacts: " + e.getMessage(), e);
        }
        try {
            this.invalidateProccessedProjectCache();
        }
        catch (Exception e) {
            throw new RepositoryAssemblyException("Error invalidating the processed project cache.", e);
        }
        ArtifactFilter filter = this.buildRepositoryFilter(repository, project);
        this.assembleRepositoryArtifacts(result, filter, project, localRepository, targetRepository, repositoryDirectory, groupVersionAlignments);
        ArtifactRepository centralRepository = this.findCentralRepository(project);
        if (repository.isIncludeMetadata()) {
            this.assembleRepositoryMetadata(result, filter, centralRepository, targetRepository);
        }
    }

    private ArtifactFilter buildRepositoryFilter(RepositoryInfo repository, MavenProject project) {
        AndArtifactFilter filter = new AndArtifactFilter();
        ScopeArtifactFilter scopeFilter = new ScopeArtifactFilter(repository.getScope());
        filter.add((ArtifactFilter)scopeFilter);
        if (repository.getIncludes().isEmpty()) {
            ArrayList<String> patterns = new ArrayList<String>();
            Set projectArtifacts = project.getDependencyArtifacts();
            if (projectArtifacts != null) {
                Iterator it = projectArtifacts.iterator();
                while (it.hasNext()) {
                    Artifact artifact = (Artifact)it.next();
                    patterns.add(artifact.getDependencyConflictId());
                }
            }
            PatternIncludesArtifactFilter includeFilter = new PatternIncludesArtifactFilter(patterns, true);
            filter.add((ArtifactFilter)includeFilter);
        } else {
            filter.add((ArtifactFilter)new PatternIncludesArtifactFilter(repository.getIncludes(), true));
        }
        if (!repository.getExcludes().isEmpty()) {
            filter.add((ArtifactFilter)new PatternExcludesArtifactFilter(repository.getExcludes(), true));
        }
        return filter;
    }

    private void assembleRepositoryArtifacts(ArtifactResolutionResult result, ArtifactFilter filter, MavenProject project, ArtifactRepository localRepository, ArtifactRepository targetRepository, File repositoryDirectory, Map groupVersionAlignments) throws RepositoryAssemblyException {
        try {
            FileUtils.deleteDirectory((File)repositoryDirectory);
            FileUtils.mkdir((String)repositoryDirectory.getAbsolutePath());
            Iterator i = result.getArtifacts().iterator();
            block5: while (i.hasNext()) {
                Artifact a = (Artifact)i.next();
                if (!filter.include(a)) continue;
                this.setAlignment(a, groupVersionAlignments);
                a.setResolved(false);
                this.artifactResolver.resolve(a, project.getRemoteArtifactRepositories(), localRepository);
                File targetFile = new File(targetRepository.getBasedir(), targetRepository.pathOf(a));
                FileUtils.copyFile((File)a.getFile(), (File)targetFile);
                this.writeChecksums(targetFile);
                if ("pom".equals(a.getType())) continue;
                a = this.artifactFactory.createProjectArtifact(a.getGroupId(), a.getArtifactId(), a.getVersion());
                MavenProject p = this.projectBuilder.buildFromRepository(a, project.getRemoteArtifactRepositories(), localRepository);
                do {
                    a = this.artifactFactory.createProjectArtifact(p.getGroupId(), p.getArtifactId(), p.getVersion());
                    this.setAlignment(a, groupVersionAlignments);
                    File sourceFile = new File(localRepository.getBasedir(), localRepository.pathOf(a));
                    if (!sourceFile.exists()) continue block5;
                    targetFile = new File(targetRepository.getBasedir(), targetRepository.pathOf(a));
                    FileUtils.copyFile((File)sourceFile, (File)targetFile);
                    this.writeChecksums(targetFile);
                } while ((p = p.getParent()) != null);
            }
        }
        catch (ArtifactResolutionException e) {
            throw new RepositoryAssemblyException("Error resolving artifacts: " + e.getMessage(), e);
        }
        catch (ArtifactNotFoundException e) {
            throw new RepositoryAssemblyException("Error resolving artifacts: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RepositoryAssemblyException("Error writing artifact metdata.", e);
        }
        catch (ProjectBuildingException e) {
            throw new RepositoryAssemblyException("Error reading POM.", e);
        }
    }

    private ArtifactRepository findCentralRepository(MavenProject project) {
        ArtifactRepository centralRepository = null;
        Iterator i = project.getRemoteArtifactRepositories().iterator();
        while (i.hasNext()) {
            ArtifactRepository r = (ArtifactRepository)i.next();
            if (!"central".equals(r.getId())) continue;
            centralRepository = r;
        }
        return centralRepository;
    }

    private void assembleRepositoryMetadata(ArtifactResolutionResult result, ArtifactFilter filter, ArtifactRepository centralRepository, ArtifactRepository targetRepository) throws RepositoryAssemblyException {
        Iterator i = result.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact a = (Artifact)i.next();
            if (!filter.include(a)) continue;
            Versioning v = new Versioning();
            v.setRelease(a.getVersion());
            v.setLatest(a.getVersion());
            v.addVersion(a.getVersion());
            v.setLastUpdated(DefaultRepositoryAssembler.getUtcDateFormatter().format(new Date()));
            ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(a, v);
            String path = targetRepository.pathOfLocalRepositoryMetadata((ArtifactMetadata)metadata, centralRepository);
            File metadataFile = new File(targetRepository.getBasedir(), path);
            MetadataXpp3Writer metadataWriter = new MetadataXpp3Writer();
            FileWriter writer = null;
            try {
                writer = new FileWriter(metadataFile);
                metadataWriter.write((Writer)writer, metadata.getMetadata());
            }
            catch (IOException e) {
                try {
                    throw new RepositoryAssemblyException("Error writing artifact metdata.", e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(writer);
                    throw throwable;
                }
            }
            IOUtil.close((Writer)writer);
            try {
                this.writeChecksums(metadataFile);
                File metadataFileRemote = new File(targetRepository.getBasedir(), targetRepository.pathOfRemoteRepositoryMetadata((ArtifactMetadata)metadata));
                FileUtils.copyFile((File)metadataFile, (File)metadataFileRemote);
                FileUtils.copyFile((File)new File(metadataFile.getParentFile(), metadataFile.getName() + ".sha1"), (File)new File(metadataFileRemote.getParentFile(), metadataFileRemote.getName() + ".sha1"));
                FileUtils.copyFile((File)new File(metadataFile.getParentFile(), metadataFile.getName() + ".md5"), (File)new File(metadataFileRemote.getParentFile(), metadataFileRemote.getName() + ".md5"));
            }
            catch (IOException e) {
                throw new RepositoryAssemblyException("Error writing artifact metdata.", e);
            }
        }
    }

    private void writeChecksums(File file) throws IOException, RepositoryAssemblyException {
        try {
            String md5 = DigestUtils.createChecksum(file, "MD5");
            String sha1 = DigestUtils.createChecksum(file, "SHA-1");
            FileUtils.fileWrite((String)new File(file.getParentFile(), file.getName() + ".md5").getAbsolutePath(), (String)md5.toLowerCase());
            FileUtils.fileWrite((String)new File(file.getParentFile(), file.getName() + ".sha1").getAbsolutePath(), (String)sha1.toLowerCase());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RepositoryAssemblyException("Unable to get write checksums: " + e.getMessage(), e);
        }
    }

    protected Map createGroupVersionAlignments(List versionAlignments) {
        HashMap<String, GroupVersionAlignment> groupVersionAlignments = new HashMap<String, GroupVersionAlignment>();
        Iterator i = versionAlignments.iterator();
        while (i.hasNext()) {
            GroupVersionAlignment alignment = (GroupVersionAlignment)i.next();
            groupVersionAlignments.put(alignment.getId(), alignment);
        }
        return groupVersionAlignments;
    }

    protected static DateFormat getUtcDateFormatter() {
        SimpleDateFormat utcDateFormatter = new SimpleDateFormat(UTC_TIMESTAMP_PATTERN);
        utcDateFormatter.setTimeZone(UTC_TIME_ZONE);
        return utcDateFormatter;
    }

    protected ArtifactRepository createLocalRepository(File directory) {
        String localRepositoryUrl = directory.getAbsolutePath();
        if (!localRepositoryUrl.startsWith("file:")) {
            localRepositoryUrl = "file://" + localRepositoryUrl;
        }
        return this.createRepository("local", localRepositoryUrl, false, true, "warn");
    }

    public ArtifactRepository createRepository(String repositoryId, String repositoryUrl, boolean offline, boolean updateSnapshots, String globalChecksumPolicy) {
        DefaultArtifactRepository localRepository = new DefaultArtifactRepository(repositoryId, repositoryUrl, this.repositoryLayout);
        boolean snapshotPolicySet = false;
        if (offline) {
            snapshotPolicySet = true;
        }
        if (!snapshotPolicySet && updateSnapshots) {
            this.artifactRepositoryFactory.setGlobalUpdatePolicy("always");
        }
        this.artifactRepositoryFactory.setGlobalChecksumPolicy(globalChecksumPolicy);
        return localRepository;
    }

    private void invalidateProccessedProjectCache() throws Exception {
        Class klass = class$org$apache$maven$project$DefaultMavenProjectBuilder == null ? (class$org$apache$maven$project$DefaultMavenProjectBuilder = DefaultRepositoryAssembler.class$("org.apache.maven.project.DefaultMavenProjectBuilder")) : class$org$apache$maven$project$DefaultMavenProjectBuilder;
        Field field = klass.getDeclaredField("processedProjectCache");
        ((AccessibleObject)field).setAccessible(true);
        Object cache = field.get(this.projectBuilder);
        cache.getClass().getDeclaredMethod("clear", null).invoke(cache, null);
        ((AccessibleObject)field).setAccessible(false);
    }

    private void setAlignment(Artifact artifact, Map groupVersionAlignments) {
        GroupVersionAlignment alignment = (GroupVersionAlignment)groupVersionAlignments.get(artifact.getGroupId());
        if (alignment != null && !alignment.getExcludes().contains(artifact.getArtifactId())) {
            artifact.setVersion(alignment.getVersion());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

