/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.war.Overlay;
import org.apache.maven.plugin.war.overlay.OverlayManager;
import org.apache.maven.plugin.war.packaging.AbstractWarPackagingTask;
import org.apache.maven.plugin.war.packaging.DependenciesAnalysisPackagingTask;
import org.apache.maven.plugin.war.packaging.OverlayPackagingTask;
import org.apache.maven.plugin.war.packaging.SaveWebappStructurePostPackagingTask;
import org.apache.maven.plugin.war.packaging.WarPackagingContext;
import org.apache.maven.plugin.war.packaging.WarPackagingTask;
import org.apache.maven.plugin.war.packaging.WarPostPackagingTask;
import org.apache.maven.plugin.war.packaging.WarProjectPackagingTask;
import org.apache.maven.plugin.war.util.WebappStructure;
import org.apache.maven.plugin.war.util.WebappStructureSerializer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractWarMojo
extends AbstractMojo {
    private MavenProject project;
    private File classesDirectory;
    private boolean archiveClasses;
    private JarArchiver jarArchiver;
    private File webappDirectory;
    private File warSourceDirectory;
    private Resource[] webResources;
    private List filters;
    private File webXml;
    private File containerConfigXML;
    private File workDirectory;
    private String outputFileNameMapping;
    private File cacheFile;
    private boolean useCache = true;
    private ArchiverManager archiverManager;
    private MavenFileFilter mavenFileFilter;
    private MavenResourcesFiltering mavenResourcesFiltering;
    private static final String WEB_INF = "WEB-INF";
    private static final String META_INF = "META-INF";
    public static final String DEFAULT_FILE_NAME_MAPPING_CLASSIFIER = "@{artifactId}@-@{version}@-@{classifier}@.@{extension}@";
    public static final String DEFAULT_FILE_NAME_MAPPING = "@{artifactId}@-@{version}@.@{extension}@";
    private String warSourceIncludes = "**";
    private String warSourceExcludes;
    private String dependentWarIncludes = "**/**";
    private String dependentWarExcludes = "META-INF/**";
    private List overlays = new ArrayList();
    private List nonFilteredFileExtensions;
    private MavenSession session;
    private boolean filteringDeploymentDescriptors = false;
    private boolean escapedBackslashesInFilePath = false;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final WebappStructureSerializer webappStructureSerialier = new WebappStructureSerializer();

    protected String[] getExcludes() {
        ArrayList<String> excludeList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)this.warSourceExcludes)) {
            excludeList.addAll(Arrays.asList(StringUtils.split((String)this.warSourceExcludes, (String)",")));
        }
        if (this.webXml != null && StringUtils.isNotEmpty((String)this.webXml.getName())) {
            excludeList.add("**/WEB-INF/web.xml");
        }
        if (this.containerConfigXML != null && StringUtils.isNotEmpty((String)this.containerConfigXML.getName())) {
            excludeList.add("**/META-INF/" + this.containerConfigXML.getName());
        }
        return excludeList.toArray(EMPTY_STRING_ARRAY);
    }

    protected String[] getIncludes() {
        return StringUtils.split((String)StringUtils.defaultString((Object)this.warSourceIncludes), (String)",");
    }

    protected String[] getDependentWarExcludes() {
        String[] excludes = StringUtils.isNotEmpty((String)this.dependentWarExcludes) ? StringUtils.split((String)this.dependentWarExcludes, (String)",") : EMPTY_STRING_ARRAY;
        return excludes;
    }

    protected String[] getDependentWarIncludes() {
        return StringUtils.split((String)StringUtils.defaultString((Object)this.dependentWarIncludes), (String)",");
    }

    public void buildExplodedWebapp(File webappDirectory) throws MojoExecutionException, MojoFailureException {
        webappDirectory.mkdirs();
        try {
            this.buildWebapp(this.project, webappDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not build webapp", (Exception)e);
        }
    }

    public void buildWebapp(MavenProject project, File webappDirectory) throws MojoExecutionException, MojoFailureException, IOException {
        WebappStructure cache = this.useCache && this.cacheFile.exists() ? new WebappStructure(project.getDependencies(), this.webappStructureSerialier.fromXml(this.cacheFile)) : new WebappStructure(project.getDependencies(), null);
        long startTime = System.currentTimeMillis();
        this.getLog().info((CharSequence)("Assembling webapp[" + project.getArtifactId() + "] in [" + webappDirectory + "]"));
        OverlayManager overlayManager = new OverlayManager(this.overlays, project, this.dependentWarIncludes, this.dependentWarExcludes);
        List packagingTasks = this.getPackagingTasks(overlayManager);
        List defaultFilterWrappers = null;
        try {
            defaultFilterWrappers = this.mavenFileFilter.getDefaultFilterWrappers(project, this.filters, this.escapedBackslashesInFilePath, this.session);
        }
        catch (MavenFilteringException e) {
            this.getLog().error((CharSequence)("fail to build filering wrappers " + e.getMessage()));
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        DefaultWarPackagingContext context = new DefaultWarPackagingContext(webappDirectory, cache, overlayManager, defaultFilterWrappers, this.getNonFilteredFileExtensions(), this.filteringDeploymentDescriptors);
        Iterator it = packagingTasks.iterator();
        while (it.hasNext()) {
            WarPackagingTask warPackagingTask = (WarPackagingTask)it.next();
            warPackagingTask.performPackaging(context);
        }
        List postPackagingTasks = this.getPostPackagingTasks();
        Iterator it2 = postPackagingTasks.iterator();
        while (it2.hasNext()) {
            WarPostPackagingTask task = (WarPostPackagingTask)it2.next();
            task.performPostPackaging(context);
        }
        this.getLog().info((CharSequence)("Webapp assembled in[" + (System.currentTimeMillis() - startTime) + " msecs]"));
    }

    private List getPackagingTasks(OverlayManager overlayManager) throws MojoExecutionException {
        ArrayList<AbstractWarPackagingTask> packagingTasks = new ArrayList<AbstractWarPackagingTask>();
        if (this.useCache) {
            packagingTasks.add(new DependenciesAnalysisPackagingTask());
        }
        List resolvedOverlays = overlayManager.getOverlays();
        Iterator it = resolvedOverlays.iterator();
        while (it.hasNext()) {
            Overlay overlay = (Overlay)it.next();
            if (overlay.isCurrentProject()) {
                packagingTasks.add(new WarProjectPackagingTask(this.webResources, this.webXml, this.containerConfigXML));
                continue;
            }
            packagingTasks.add(new OverlayPackagingTask(overlay));
        }
        return packagingTasks;
    }

    private List getPostPackagingTasks() {
        ArrayList<SaveWebappStructurePostPackagingTask> postPackagingTasks = new ArrayList<SaveWebappStructurePostPackagingTask>();
        if (this.useCache) {
            postPackagingTasks.add(new SaveWebappStructurePostPackagingTask(this.cacheFile));
        }
        return postPackagingTasks;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public void setClassesDirectory(File classesDirectory) {
        this.classesDirectory = classesDirectory;
    }

    public File getWebappDirectory() {
        return this.webappDirectory;
    }

    public void setWebappDirectory(File webappDirectory) {
        this.webappDirectory = webappDirectory;
    }

    public File getWarSourceDirectory() {
        return this.warSourceDirectory;
    }

    public void setWarSourceDirectory(File warSourceDirectory) {
        this.warSourceDirectory = warSourceDirectory;
    }

    public File getWebXml() {
        return this.webXml;
    }

    public void setWebXml(File webXml) {
        this.webXml = webXml;
    }

    public File getContainerConfigXML() {
        return this.containerConfigXML;
    }

    public void setContainerConfigXML(File containerConfigXML) {
        this.containerConfigXML = containerConfigXML;
    }

    public String getOutputFileNameMapping() {
        return this.outputFileNameMapping;
    }

    public void setOutputFileNameMapping(String outputFileNameMapping) {
        this.outputFileNameMapping = outputFileNameMapping;
    }

    public List getOverlays() {
        return this.overlays;
    }

    public void setOverlays(List overlays) {
        this.overlays = overlays;
    }

    public void addOverlay(Overlay overlay) {
        this.overlays.add(overlay);
    }

    public boolean isArchiveClasses() {
        return this.archiveClasses;
    }

    public void setArchiveClasses(boolean archiveClasses) {
        this.archiveClasses = archiveClasses;
    }

    public JarArchiver getJarArchiver() {
        return this.jarArchiver;
    }

    public void setJarArchiver(JarArchiver jarArchiver) {
        this.jarArchiver = jarArchiver;
    }

    public Resource[] getWebResources() {
        return this.webResources;
    }

    public void setWebResources(Resource[] webResources) {
        this.webResources = webResources;
    }

    public List getFilters() {
        return this.filters;
    }

    public void setFilters(List filters) {
        this.filters = filters;
    }

    public File getWorkDirectory() {
        return this.workDirectory;
    }

    public void setWorkDirectory(File workDirectory) {
        this.workDirectory = workDirectory;
    }

    public File getCacheFile() {
        return this.cacheFile;
    }

    public void setCacheFile(File cacheFile) {
        this.cacheFile = cacheFile;
    }

    public String getWarSourceIncludes() {
        return this.warSourceIncludes;
    }

    public void setWarSourceIncludes(String warSourceIncludes) {
        this.warSourceIncludes = warSourceIncludes;
    }

    public String getWarSourceExcludes() {
        return this.warSourceExcludes;
    }

    public void setWarSourceExcludes(String warSourceExcludes) {
        this.warSourceExcludes = warSourceExcludes;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public MavenArchiveConfiguration getArchive() {
        return this.archive;
    }

    public List getNonFilteredFileExtensions() {
        return this.nonFilteredFileExtensions;
    }

    public void setNonFilteredFileExtensions(List nonFilteredFileExtensions) {
        this.nonFilteredFileExtensions = nonFilteredFileExtensions;
    }

    private class DefaultWarPackagingContext
    implements WarPackagingContext {
        private final WebappStructure webappStructure;
        private final File webappDirectory;
        private final OverlayManager overlayManager;
        private final List filterWrappers;
        private List nonFilteredFileExtensions;
        private boolean filteringDeploymentDescriptors;

        public DefaultWarPackagingContext(File webappDirectory, WebappStructure webappStructure, OverlayManager overlayManager, List filterWrappers, List nonFilteredFileExtensions, boolean filteringDeploymentDescriptors) {
            this.webappDirectory = webappDirectory;
            this.webappStructure = webappStructure;
            this.overlayManager = overlayManager;
            this.filterWrappers = filterWrappers;
            this.filteringDeploymentDescriptors = filteringDeploymentDescriptors;
            this.nonFilteredFileExtensions = nonFilteredFileExtensions == null ? Collections.EMPTY_LIST : nonFilteredFileExtensions;
            Iterator it = overlayManager.getOverlayIds().iterator();
            while (it.hasNext()) {
                String overlayId = (String)it.next();
                webappStructure.getStructure(overlayId);
            }
        }

        public MavenProject getProject() {
            return AbstractWarMojo.this.project;
        }

        public File getWebappDirectory() {
            return this.webappDirectory;
        }

        public File getClassesDirectory() {
            return AbstractWarMojo.this.classesDirectory;
        }

        public Log getLog() {
            return AbstractWarMojo.this.getLog();
        }

        public String getOutputFileNameMapping() {
            return AbstractWarMojo.this.outputFileNameMapping;
        }

        public File getWebappSourceDirectory() {
            return AbstractWarMojo.this.warSourceDirectory;
        }

        public String[] getWebappSourceIncludes() {
            return AbstractWarMojo.this.getIncludes();
        }

        public String[] getWebappSourceExcludes() {
            return AbstractWarMojo.this.getExcludes();
        }

        public boolean archiveClasses() {
            return AbstractWarMojo.this.archiveClasses;
        }

        public File getOverlaysWorkDirectory() {
            return AbstractWarMojo.this.workDirectory;
        }

        public ArchiverManager getArchiverManager() {
            return AbstractWarMojo.this.archiverManager;
        }

        public MavenArchiveConfiguration getArchive() {
            return AbstractWarMojo.this.archive;
        }

        public JarArchiver getJarArchiver() {
            return AbstractWarMojo.this.jarArchiver;
        }

        public List getFilters() {
            return AbstractWarMojo.this.filters;
        }

        public WebappStructure getWebappStructure() {
            return this.webappStructure;
        }

        public List getOwnerIds() {
            return this.overlayManager.getOverlayIds();
        }

        public MavenFileFilter getMavenFileFilter() {
            return AbstractWarMojo.this.mavenFileFilter;
        }

        public List getFilterWrappers() {
            return this.filterWrappers;
        }

        public boolean isNonFilteredExtension(String fileName) {
            return !AbstractWarMojo.this.mavenResourcesFiltering.filteredFileExtension(fileName, this.nonFilteredFileExtensions);
        }

        public boolean isFilteringDeploymentDescriptors() {
            return this.filteringDeploymentDescriptors;
        }
    }
}

