/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war.util;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

public class PathSet {
    private Set pathsSet = new LinkedHashSet();

    protected String normalizeFilePath(String path) {
        return PathSet.normalizeFilePathStatic(path);
    }

    public PathSet() {
    }

    public PathSet(Collection paths) {
        this.addAll(paths);
    }

    public PathSet(String[] paths) {
        this.addAll(paths);
    }

    public void add(String path) {
        this.pathsSet.add(this.normalizeFilePath(path));
    }

    public void addAll(Collection paths, String prefix) {
        Iterator iter = paths.iterator();
        while (iter.hasNext()) {
            this.add(prefix + iter.next());
        }
    }

    public void addAll(String[] paths, String prefix) {
        for (int i = 0; i < paths.length; ++i) {
            this.add(prefix + paths[i]);
        }
    }

    public void addAll(PathSet paths, String prefix) {
        Iterator iter = paths.iterator();
        while (iter.hasNext()) {
            this.add(prefix + iter.next());
        }
    }

    public void addAll(Collection paths) {
        this.addAll(paths, "");
    }

    public void addAll(String[] paths) {
        this.addAll(paths, "");
    }

    public void addAll(PathSet paths) {
        this.addAll(paths, "");
    }

    public boolean contains(String path) {
        return this.pathsSet.contains(this.normalizeFilePath(path));
    }

    public Iterator iterator() {
        return this.pathsSet.iterator();
    }

    public void addPrefix(String prefix) {
        HashSet<String> newSet = new HashSet<String>();
        Iterator iter = this.pathsSet.iterator();
        while (iter.hasNext()) {
            String path = (String)iter.next();
            newSet.add(this.normalizeFilePath(prefix + path));
        }
        this.pathsSet = newSet;
    }

    public int size() {
        return this.pathsSet.size();
    }

    public void addAllFilesInDirectory(File directory, String prefix) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        scanner.scan();
        this.addAll(scanner.getIncludedFiles(), prefix);
    }

    public static String normalizeFilePathStatic(String path) {
        return PathSet.trimTrailingSlashes(StringUtils.replace((String)path, (char)'\\', (char)'/'));
    }

    public static String trimTrailingSlashes(String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == '/'; ++i) {
        }
        return str.substring(i);
    }
}

