/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.archivist;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.jar.Manifest;

public abstract class AbstractArchive {
    public static final AbstractArchive[] nullArray = new AbstractArchive[0];
    private CodeSource codeSource;
    private PermissionCollection permissionCollection;
    private ProtectionDomain pd;

    public abstract String getArchiveUri();

    public abstract AbstractArchive getEmbeddedArchive(String var1) throws IOException;

    public abstract void closeEntry(AbstractArchive var1) throws IOException;

    public abstract void close() throws IOException;

    public abstract InputStream getEntry(String var1) throws IOException;

    public abstract OutputStream addEntry(String var1) throws IOException;

    public abstract void closeEntry(OutputStream var1) throws IOException;

    public abstract Enumeration entries();

    public abstract Enumeration entries(Enumeration var1);

    public abstract Manifest getManifest() throws IOException;

    public abstract boolean exists();

    public abstract boolean delete();

    public abstract boolean renameTo(String var1);

    public abstract boolean supportsElementsOverwriting();

    public abstract boolean contains(String var1) throws IOException;

    public URL getEntryURL(String name) throws IOException {
        if (this.contains(name)) {
            return new URL(this.getArchiveUrl(), name);
        }
        return null;
    }

    public URL getEntryURL(String name, URLStreamHandler handler) throws IOException {
        if (this.contains(name)) {
            return new URL(this.getArchiveUrl(), name, handler);
        }
        return null;
    }

    public abstract URL getArchiveUrl();

    public void setCodeSource(CodeSource codeSource) {
        this.codeSource = codeSource;
    }

    public void setPermissionCollection(PermissionCollection permissions) {
        this.permissionCollection = permissions;
    }

    public CodeSource getCodeSource() {
        return this.codeSource;
    }

    public PermissionCollection getPermissionCollection() {
        return this.permissionCollection;
    }

    public void setProtectionDomain(ProtectionDomain pd) {
        this.pd = pd;
    }

    public ProtectionDomain getProtectionDomain() {
        return this.pd;
    }

    public String getClassFtpUri(int count) {
        return this.getArchiveUri() + "___" + count;
    }
}

