/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl.blocking;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import jeus.io.Connector;
import jeus.io.protocol.message.ssl.SSLConfiguration;

public class SSLSocketConnector
extends Connector {
    private SSLContext sslContext;
    private Map sslProperties;

    public SSLSocketConnector(Object sslContext, Map sslProperties) {
        this.sslContext = (SSLContext)sslContext;
        this.sslProperties = sslProperties;
    }

    public Socket connect(String host, int port, String localHost, int localPort, String id, int connectTimeout, int readTimeout) throws IOException {
        SSLSocket socket = (SSLSocket)this.sslContext.getSocketFactory().createSocket();
        SSLConfiguration.setSSLProperties(socket, this.sslProperties, SSLConfiguration.engineSetMethodNames, SSLConfiguration.sslSocketSetMethods);
        if (localHost != null && localPort > 0) {
            socket.bind(new InetSocketAddress(localHost, localPort));
        } else if (localHost == null && localPort > 0) {
            socket.bind(new InetSocketAddress(localPort));
        }
        socket.connect(new InetSocketAddress(host, port), connectTimeout);
        socket.setSoTimeout(readTimeout);
        socket.startHandshake();
        return socket;
    }
}

