/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl.blocking;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import jeus.io.Acceptor;
import jeus.io.SocketListener;
import jeus.util.message.JeusMessage_Network;

public class SocketAcceptor13
extends Acceptor {
    private ServerSocket server;
    private SocketListener listener;

    public SocketAcceptor13(int listenPort, SocketListener listener, int backlog, InetAddress listenHost) throws IOException {
        this(new ServerSocket(listenPort, backlog, listenHost), listener);
    }

    public SocketAcceptor13(ServerSocket server, SocketListener listener) {
        this.server = server;
        this.listener = listener;
        this.realListenPort = server.getLocalPort();
    }

    public void run() {
        while (this.isRunning()) {
            try {
                if (logger.isLoggable(JeusMessage_Network._4_LEVEL)) {
                    logger.log(JeusMessage_Network._4_LEVEL, JeusMessage_Network._4, (Object)this);
                }
                Socket socket = this.server.accept();
                if (!this.isRunning()) {
                    return;
                }
                if (logger.isLoggable(JeusMessage_Network._5_LEVEL)) {
                    logger.log(JeusMessage_Network._5_LEVEL, JeusMessage_Network._5, (Object)this);
                }
                this.listener.onSocket(socket);
                this.acceptSucceed();
            }
            catch (IOException e) {
                this.acceptFailed(e);
            }
        }
    }

    protected void destroyInternal() {
        try {
            if (logger.isLoggable(JeusMessage_Network._3_LEVEL)) {
                logger.log(JeusMessage_Network._3_LEVEL, JeusMessage_Network._3);
            }
            this.server.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getServerSocketPort() {
        return this.server.getLocalPort();
    }

    public String toString() {
        try {
            if (this.server != null) {
                return this.server.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "no server socket information";
    }
}

