/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl.nio.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import jeus.io.impl.nio.util.ByteBufferCreator;

public class ByteBufferOutputStream
extends OutputStream {
    private ByteBuffer buffer;
    private int PADDING = 200;

    public ByteBufferOutputStream(int startingSize) {
        this.buffer = ByteBufferCreator.allocateByteBuffer(true, startingSize);
    }

    public void reset() {
        this.buffer.clear();
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    public ByteBuffer setByteBuffer(int startingSize) {
        this.buffer = ByteBufferCreator.allocateByteBuffer(true, startingSize);
        return this.buffer;
    }

    public void write(int b) throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.realloc(this.buffer.limit() + this.PADDING);
        }
        this.buffer.put((byte)b);
    }

    public void write(byte[] b) {
        if (this.buffer.remaining() < b.length) {
            this.realloc(this.buffer.limit() + (b.length - this.buffer.remaining()) + this.PADDING);
        }
        this.buffer.put(b);
    }

    public void write(byte[] b, int off, int len) {
        if (this.buffer.remaining() < len) {
            this.realloc(this.buffer.limit() + (len - this.buffer.remaining()) + this.PADDING);
        }
        this.buffer.put(b, off, len);
    }

    public void realloc(int newSize) {
        ByteBuffer newBuffer = ByteBufferCreator.allocateByteBuffer(true, newSize);
        this.buffer.flip();
        newBuffer.put(this.buffer);
        ByteBufferCreator.freeByteBuffer(this.buffer);
        this.buffer = newBuffer;
    }

    public void close() {
        this.buffer = null;
    }
}

