/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl.nio.util.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import jeus.io.impl.StreamHandlerImpl;
import jeus.io.impl.nio.util.AdvancedByteBuffer;
import jeus.io.impl.nio.util.ChannelInputStreamBuffer;
import jeus.io.protocol.message.ssl.SSLContentBufferWrapper;
import jeus.io.protocol.message.ssl.SSLInputStreamBuffer;

public class SSLChannelInputStreamBuffer
extends ChannelInputStreamBuffer
implements SSLInputStreamBuffer {
    private AdvancedByteBuffer sslInBuffer;
    private SSLEngine engine;

    public SSLChannelInputStreamBuffer(StreamHandlerImpl endpoint, SSLEngine engine) {
        super(endpoint, engine.getSession().getApplicationBufferSize());
        this.engine = engine;
        this.sslInBuffer = new AdvancedByteBuffer(engine.getSession().getPacketBufferSize());
    }

    public int read() throws IOException {
        return SSLContentBufferWrapper.readSSL(this);
    }

    public AdvancedByteBuffer getInBuffer() {
        return this.advancedByteBuffer;
    }

    public SSLEngine getEngine() {
        return this.engine;
    }

    public StreamHandlerImpl getEndpoint() {
        return this.endpoint;
    }

    public AdvancedByteBuffer getSSLInBuffer() {
        return this.sslInBuffer;
    }

    public int readBuffer(ByteBuffer inBuffer) throws IOException {
        return super.readBuffer(inBuffer);
    }
}

