/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.protocol.message;

import java.io.IOException;
import java.nio.ByteBuffer;
import jeus.io.handler.StreamContentBuffer;
import jeus.io.handler.StreamContentBufferWrapper;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.handler.StreamContentReader;
import jeus.io.handler.StreamContentWriter;
import jeus.io.handler.StreamContentWriterWrapper;
import jeus.io.impl.StreamHandlerImpl;
import jeus.io.impl.blocking.protocol.message.BlockingContentBuffer;
import jeus.io.impl.blocking.protocol.message.BlockingContentWriter;
import jeus.io.impl.blockingChannel.protocol.message.BlockingChannelContentBuffer;
import jeus.io.impl.nio.protocol.message.NIOContentBuffer;
import jeus.io.impl.nio.protocol.message.NIOContentWriter;
import jeus.io.impl.nio.util.ByteBufferCreator;
import jeus.io.protocol.message.ContentReader;

public class ContentHandlerCreator
implements StreamContentHandlerCreator {
    protected ClassLoader classloader = (class$jeus$io$protocol$message$ContentHandlerCreator == null ? (class$jeus$io$protocol$message$ContentHandlerCreator = ContentHandlerCreator.class$("jeus.io.protocol.message.ContentHandlerCreator")) : class$jeus$io$protocol$message$ContentHandlerCreator).getClassLoader();
    protected StreamContentBufferWrapper contentBufferWrapper;
    private StreamContentWriterWrapper contentWriterWrapper;
    static /* synthetic */ Class class$jeus$io$protocol$message$ContentHandlerCreator;

    public ContentHandlerCreator() {
    }

    public ContentHandlerCreator(ClassLoader loader) {
        this.classloader = loader;
    }

    public StreamContentReader createContentReader(StreamHandlerImpl endpoint, int selectorType) throws IOException {
        StreamContentBuffer contentBuffer = this.createContentBuffer(selectorType, endpoint);
        if (this.contentBufferWrapper != null) {
            return new ContentReader(endpoint, this.contentBufferWrapper.createStreamContentBuffer(selectorType, contentBuffer, endpoint));
        }
        return new ContentReader(endpoint, contentBuffer);
    }

    public StreamContentBuffer createContentBuffer(int selectorType, StreamHandlerImpl endpoint) throws IOException {
        switch (selectorType) {
            case 2: {
                return new BlockingContentBuffer(endpoint, this.classloader);
            }
            case 3: {
                return new BlockingChannelContentBuffer(endpoint, this.classloader);
            }
            case 1: {
                return new NIOContentBuffer(endpoint, this.classloader);
            }
        }
        throw new RuntimeException("no");
    }

    public final StreamContentWriter createContentWriter(int selectorType, StreamHandlerImpl endpoint) {
        StreamContentWriter contentWriter = this.createContentWriterInternal(selectorType, endpoint);
        if (this.contentWriterWrapper != null) {
            return this.contentWriterWrapper.createContentWriter(selectorType, contentWriter, endpoint);
        }
        return contentWriter;
    }

    protected StreamContentWriter createContentWriterInternal(int selectorType, StreamHandlerImpl endpoint) {
        switch (selectorType) {
            case 2: {
                return new BlockingContentWriter(this.classloader);
            }
            case 1: 
            case 3: 
            case 4: {
                return new NIOContentWriter(this.classloader);
            }
        }
        throw new RuntimeException("no");
    }

    public ByteBuffer createByteBuffer(int size) {
        ByteBuffer buffer = ByteBufferCreator.allocateByteBuffer(true, size + 8);
        buffer.position(8);
        return buffer;
    }

    public void setStreamContentWriterWrapper(StreamContentWriterWrapper contentWriterWrapper) {
        this.contentWriterWrapper = contentWriterWrapper;
    }

    public void setStreamContentBufferWrapper(StreamContentBufferWrapper bufferWrapper) {
        this.contentBufferWrapper = bufferWrapper;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

