/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.protocol.message;

import java.io.IOException;
import jeus.io.handler.StreamContentBuffer;
import jeus.io.handler.StreamContentReader;
import jeus.io.impl.StreamHandlerImpl;
import jeus.io.protocol.message.MessageConstant;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Network;

public class ContentReader
implements StreamContentReader,
MessageConstant {
    private int readState = 0;
    private StreamHandlerImpl streamHandler;
    private int msgType;
    private StreamContentBuffer buffer;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.io");

    public ContentReader(StreamHandlerImpl streamHandlerChannel, StreamContentBuffer buffer) {
        this.streamHandler = streamHandlerChannel;
        this.buffer = buffer;
    }

    public Object readMessage() throws Exception {
        boolean motor = true;
        int msgLen = 0;
        try {
            while (motor && !this.streamHandler.isClosed()) {
                switch (this.readState) {
                    case 0: {
                        this.buffer.resetBuffer(4);
                        if (logger.isLoggable(JeusMessage_Network._304_LEVEL)) {
                            logger.log(JeusMessage_Network._304_LEVEL, JeusMessage_Network._304, (Object)this.streamHandler.getSocket());
                        }
                        this.readState = 1;
                    }
                    case 1: {
                        motor = this.buffer.readBuffer();
                        if (logger.isLoggable(JeusMessage_Network._305_LEVEL)) {
                            logger.log(JeusMessage_Network._305_LEVEL, JeusMessage_Network._305, new Object[]{motor ? Boolean.TRUE : Boolean.FALSE, this.streamHandler.getSocket()});
                        }
                        if (!motor) break;
                        this.readState = 2;
                    }
                    case 2: {
                        this.msgType = this.buffer.readIntFromBuffer();
                        if (logger.isLoggable(JeusMessage_Network._306_LEVEL)) {
                            logger.log(JeusMessage_Network._306_LEVEL, JeusMessage_Network._306, new Object[]{Integer.toString(this.msgType), this.streamHandler.getSocket()});
                        }
                        this.readState = 3;
                    }
                    case 3: {
                        switch (this.msgType) {
                            case 133763771: 
                            case 133763772: 
                            case 150606573: 
                            case 150606574: {
                                this.buffer.resetBuffer(4);
                                if (logger.isLoggable(JeusMessage_Network._307_LEVEL)) {
                                    logger.log(JeusMessage_Network._307_LEVEL, JeusMessage_Network._307, (Object)this.streamHandler.getSocket());
                                }
                                this.readState = 4;
                                break;
                            }
                            default: {
                                this.readState = 0;
                                throw new IOException("Bad magic number for Generic Message Protocol 0x" + Integer.toHexString(this.msgType));
                            }
                        }
                    }
                    case 4: {
                        motor = this.buffer.readBuffer();
                        if (logger.isLoggable(JeusMessage_Network._308_LEVEL)) {
                            logger.log(JeusMessage_Network._308_LEVEL, JeusMessage_Network._308, new Object[]{motor ? Boolean.TRUE : Boolean.FALSE, this.streamHandler.getSocket()});
                        }
                        if (!motor) break;
                        this.readState = 5;
                    }
                    case 5: {
                        msgLen = this.buffer.readIntFromBuffer();
                        if (logger.isLoggable(JeusMessage_Network._309_LEVEL)) {
                            logger.log(JeusMessage_Network._309_LEVEL, JeusMessage_Network._309, new Object[]{Integer.toString(msgLen), this.streamHandler.getSocket()});
                        }
                        this.readState = 6;
                    }
                    case 6: {
                        this.buffer.resetBuffer(msgLen);
                        if (logger.isLoggable(JeusMessage_Network._310_LEVEL)) {
                            logger.log(JeusMessage_Network._310_LEVEL, JeusMessage_Network._310, (Object)this.streamHandler.getSocket());
                        }
                        this.readState = 7;
                    }
                    case 7: {
                        motor = this.buffer.readBuffer();
                        if (logger.isLoggable(JeusMessage_Network._311_LEVEL)) {
                            logger.log(JeusMessage_Network._311_LEVEL, JeusMessage_Network._311, new Object[]{motor ? Boolean.TRUE : Boolean.FALSE, this.streamHandler.getSocket()});
                        }
                        if (!motor) break;
                        this.readState = 8;
                    }
                    case 8: {
                        if (logger.isLoggable(JeusMessage_Network._312_LEVEL)) {
                            logger.log(JeusMessage_Network._312_LEVEL, JeusMessage_Network._312, new Object[]{motor ? Boolean.TRUE : Boolean.FALSE, this.streamHandler.getSocket()});
                        }
                        switch (this.msgType) {
                            case 150606574: {
                                this.readState = 0;
                                return this.buffer.readObjectFromBuffer();
                            }
                            case 133763771: {
                                this.readState = 0;
                                return this.buffer.readByteArrayFromBuffer();
                            }
                            case 150606573: {
                                this.readState = 0;
                                byte[] header = this.readHeader();
                                Object msg = this.buffer.readObjectFromBuffer();
                                return new Object[]{msg, header};
                            }
                            case 133763772: {
                                this.readState = 0;
                                byte[] header = this.readHeader();
                                byte[] bytes = this.buffer.readByteArrayFromBuffer();
                                return new Object[]{bytes, header};
                            }
                        }
                        throw new RuntimeException();
                    }
                }
            }
        }
        catch (Exception ex) {
            this.readState = 0;
            throw ex;
        }
        return null;
    }

    public Object getPiggybackData(byte[] data) throws IOException {
        return null;
    }

    private byte[] readHeader() throws IOException {
        int headerLength = this.buffer.readIntFromBuffer();
        byte[] header = this.buffer.readByteArrayFromBuffer(headerLength);
        this.buffer.decreaseAppLength(headerLength + 4);
        return header;
    }

    public void close() {
        this.buffer.close();
    }

    public void eventOccurred(String event) {
    }
}

