/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.protocol.message.ssl;

import java.io.IOException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import jeus.io.handler.StreamContentBuffer;
import jeus.io.handler.StreamContentBufferWrapper;
import jeus.io.handler.StreamHandler;
import jeus.io.impl.StreamHandlerImpl;
import jeus.io.impl.blockingChannel.util.ssl.SSLBlockingChannelInputStreamBuffer;
import jeus.io.impl.nio.protocol.message.NIOContentBuffer;
import jeus.io.impl.nio.util.AdvancedByteBuffer;
import jeus.io.impl.nio.util.ByteBufferCreator;
import jeus.io.impl.nio.util.ssl.SSLChannelInputStreamBuffer;
import jeus.io.protocol.message.ssl.SSLContentWriter;
import jeus.io.protocol.message.ssl.SSLInputStreamBuffer;

public class SSLContentBufferWrapper
implements StreamContentBufferWrapper {
    private SSLEngine engine;

    public SSLContentBufferWrapper(SSLEngine sslEngine) {
        this.engine = sslEngine;
    }

    public StreamContentBuffer createStreamContentBuffer(int selectorType, StreamContentBuffer delegateBuffer, StreamHandler streamHandler) {
        switch (selectorType) {
            case 2: {
                return delegateBuffer;
            }
            case 3: {
                SSLBlockingChannelInputStreamBuffer channelBuffer = new SSLBlockingChannelInputStreamBuffer((StreamHandlerImpl)streamHandler, this.engine);
                ((NIOContentBuffer)delegateBuffer).setInputStreamBuffer(channelBuffer);
                return delegateBuffer;
            }
            case 1: {
                SSLChannelInputStreamBuffer channelBuffer = new SSLChannelInputStreamBuffer((StreamHandlerImpl)streamHandler, this.engine);
                ((NIOContentBuffer)delegateBuffer).setInputStreamBuffer(channelBuffer);
                return delegateBuffer;
            }
        }
        throw new RuntimeException("no");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readSSL(SSLInputStreamBuffer streamBuffer) throws IOException {
        AdvancedByteBuffer sslInBuffer = streamBuffer.getSSLInBuffer();
        AdvancedByteBuffer inBuffer = streamBuffer.getInBuffer();
        SSLEngine engine = streamBuffer.getEngine();
        StreamHandlerImpl endpoint = streamBuffer.getEndpoint();
        if (SSLContentBufferWrapper.readSSLInputBuffer(streamBuffer) > 0) {
            SSLEngineResult engineResult;
            SSLEngine sSLEngine = engine;
            synchronized (sSLEngine) {
                SSLEngineResult.HandshakeStatus handshakeStatus = engine.getHandshakeStatus();
                boolean shouldNotifyAll = handshakeStatus.equals((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
                engineResult = engine.unwrap(sslInBuffer.getByteBuffer(), inBuffer.getByteBuffer());
                if (shouldNotifyAll) {
                    engine.notifyAll();
                }
            }
            SSLEngineResult.Status status = engineResult.getStatus();
            if (status == SSLEngineResult.Status.OK) {
                SSLContentBufferWrapper.checkHandshake(engine, streamBuffer);
            } else {
                if (status == SSLEngineResult.Status.CLOSED) {
                    endpoint.reportException(new IOException("SSLEngine closed"));
                    engine.closeInbound();
                    return -1;
                }
                if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    inBuffer.ensureWhileReadingBuffer(engine.getSession().getApplicationBufferSize());
                } else if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    // empty if block
                }
            }
        }
        return inBuffer.position();
    }

    private static int readSSLInputBuffer(SSLInputStreamBuffer streamBuffer) throws IOException {
        AdvancedByteBuffer sslInBuffer = streamBuffer.getSSLInBuffer();
        int packetBufferSize = streamBuffer.getEngine().getSession().getPacketBufferSize();
        sslInBuffer.ensureWhileReadingBuffer(packetBufferSize);
        streamBuffer.readBuffer(sslInBuffer.getByteBuffer());
        sslInBuffer.flip();
        return sslInBuffer.remaining();
    }

    /*
     * Unable to fully structure code
     */
    private static boolean checkHandshake(SSLEngine engine, SSLInputStreamBuffer streamBuffer) throws IOException {
        var2_2 = engine;
        synchronized (var2_2) {
            block3: while (true) {
                if ((handshakeStatus = engine.getHandshakeStatus()) == SSLEngineResult.HandshakeStatus.FINISHED || handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    return true;
                }
                if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    SSLContentWriter.writeSSLOutBuffer(engine, streamBuffer.getEndpoint(), ByteBufferCreator.dummyBuffers);
                    continue;
                }
                if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    sslInBuffer = streamBuffer.getSSLInBuffer();
                    if (!sslInBuffer.hasRemaining()) {
                        return false;
                    }
                    position = sslInBuffer.position();
                    inBuffer = streamBuffer.getInBuffer();
                    engine.unwrap(sslInBuffer.getByteBuffer(), inBuffer.getByteBuffer());
                    if (position != sslInBuffer.position()) continue;
                    return false;
                }
                if (handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK) break;
                runnable = engine.getDelegatedTask();
                while (true) {
                    if (runnable != null) ** break;
                    continue block3;
                    runnable.run();
                    runnable = engine.getDelegatedTask();
                }
                break;
            }
            throw new RuntimeException("never");
        }
    }
}

