/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.protocol.message.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import jeus.io.handler.StreamContentWriter;
import jeus.io.handler.StreamHandler;
import jeus.io.impl.nio.util.ByteBufferCreator;
import jeus.io.protocol.message.ContentWriter;

public class SSLContentWriter
extends ContentWriter {
    private final SSLEngine engine;
    private StreamContentWriter delegateContentWriter;
    private StreamHandler endpoint;

    public SSLContentWriter(SSLEngine engine, StreamContentWriter contentWriter, StreamHandler endpoint) {
        this.engine = engine;
        this.delegateContentWriter = contentWriter;
        this.endpoint = endpoint;
    }

    public Object[] getBufferToBeWrite(Object toBeWrite, byte[] header) throws IOException {
        Object[] buffer = this.delegateContentWriter.getBufferToBeWrite(toBeWrite, header);
        return this.getSSLBuffer(buffer);
    }

    public Object[] getBufferToBeWrite(byte[] bytes, int offset, int length, byte[] header) throws IOException {
        Object[] buffer = this.delegateContentWriter.getBufferToBeWrite(bytes, offset, length, header);
        return this.getSSLBuffer(buffer);
    }

    public boolean canWritePiggybackDataAsByte(Object packet) {
        return this.delegateContentWriter.canWritePiggybackDataAsByte(packet);
    }

    public byte[] getPiggybackDataBuffer(Object packet) throws IOException {
        return this.delegateContentWriter.getPiggybackDataBuffer(packet);
    }

    public ObjectOutputStream makeOutputStream(OutputStream bbis) throws IOException {
        return this.delegateContentWriter.makeOutputStream(bbis);
    }

    public ObjectInputStream makeInputStream(InputStream bbis) throws IOException {
        return this.delegateContentWriter.makeInputStream(bbis);
    }

    public Object[] getBufferToBeWrite(ByteBuffer byteBuffer, byte[] header) throws IOException {
        Object[] buffer = this.delegateContentWriter.getBufferToBeWrite(byteBuffer, header);
        return this.getSSLBuffer(buffer);
    }

    private Object[] getSSLBuffer(Object[] buffer) throws IOException {
        SSLEngineResult.Status status;
        ByteBuffer[] buffers = (ByteBuffer[])buffer;
        ByteBuffer lastBuffer = buffers[buffers.length - 1];
        while (true) {
            SSLEngineResult engineResult;
            if ((status = (engineResult = SSLContentWriter.writeSSLOutBuffer(this.engine, this.endpoint, buffers)).getStatus()) == SSLEngineResult.Status.OK) {
                if (!this.checkHandshake() || lastBuffer.hasRemaining()) continue;
                return null;
            }
            if (status != SSLEngineResult.Status.BUFFER_OVERFLOW && status != SSLEngineResult.Status.BUFFER_UNDERFLOW) break;
        }
        if (status == SSLEngineResult.Status.CLOSED) {
            throw new IOException("SSLEngine closed");
        }
        throw new RuntimeException("never");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLEngineResult writeSSLOutBuffer(SSLEngine engine, StreamHandler endpoint, ByteBuffer[] buffers) throws IOException {
        SSLEngineResult engineResult;
        ByteBuffer sslOutBuffer = ByteBufferCreator.allocateByteBuffer(true, engine.getSession().getPacketBufferSize());
        SSLEngine sSLEngine = engine;
        synchronized (sSLEngine) {
            engineResult = buffers.length == 1 ? engine.wrap(buffers[0], sslOutBuffer) : engine.wrap(buffers, sslOutBuffer);
            sslOutBuffer.flip();
            if (sslOutBuffer.hasRemaining()) {
                endpoint.writeInternal(new ByteBuffer[]{sslOutBuffer});
            }
        }
        return engineResult;
    }

    private boolean checkHandshake() throws IOException {
        SSLEngine sSLEngine = this.engine;
        synchronized (sSLEngine) {
            block5: while (true) {
                SSLEngineResult.HandshakeStatus handshakeStatus;
                if ((handshakeStatus = this.engine.getHandshakeStatus()) == SSLEngineResult.HandshakeStatus.FINISHED || handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    return true;
                }
                if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    return false;
                }
                if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    try {
                        this.engine.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    return true;
                }
                if (handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK) break;
                Runnable runnable = this.engine.getDelegatedTask();
                while (true) {
                    if (runnable == null) continue block5;
                    runnable.run();
                    runnable = this.engine.getDelegatedTask();
                }
                break;
            }
            throw new RuntimeException("never");
        }
    }
}

