/*
 * Decompiled with CFR 0.152.
 */
package jeus.net.impl;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import jeus.io.impl.IStreamHandler14;
import jeus.io.impl.StreamHandlerImpl;
import jeus.net.ConnectionListener;
import jeus.net.ReplyListener;
import jeus.net.SocketStream;
import jeus.net.impl.ConnectionManager;
import jeus.util.message.JeusMessage_Network;

public class SocketStream14
extends SocketStream {
    private IStreamHandler14 endpoint14;

    public SocketStream14(Socket _socket, ConnectionManager connectionManager, ConnectionListener listener, boolean onlyByteTransfer) {
        super(_socket, connectionManager, listener, onlyByteTransfer);
    }

    public void setEndpoint(StreamHandlerImpl endpoint) {
        super.setEndpoint(endpoint);
        this.endpoint14 = (IStreamHandler14)((Object)endpoint);
    }

    public boolean write(ByteBuffer message, ReplyListener receiver) throws IOException {
        if (this.endpoint == null) {
            throw new IOException("connection is not established");
        }
        byte[] requestHeader = this.makeRequestHeader(receiver);
        boolean result = this.endpoint14.write(message, requestHeader);
        if (logger.isLoggable(JeusMessage_Network._413_LEVEL)) {
            logger.log(JeusMessage_Network._413_LEVEL, JeusMessage_Network._413, new Object[]{message, this.socketString});
        }
        return result;
    }

    public boolean write(ByteBuffer message) throws IOException {
        if (this.endpoint == null) {
            throw new IOException("connection is not established");
        }
        boolean result = this.endpoint14.write(message);
        if (logger.isLoggable(JeusMessage_Network._413_LEVEL)) {
            logger.log(JeusMessage_Network._413_LEVEL, JeusMessage_Network._413, new Object[]{message, this.socketString});
        }
        return result;
    }

    public ByteBuffer getByteBuffer(int size) {
        return this.endpoint14.createByteBuffer(size);
    }

    public ByteBuffer getReqeustByteBuffer(int size) {
        int headerLength = 12;
        ByteBuffer buffer = this.endpoint14.createByteBuffer(size + headerLength);
        buffer.position(buffer.position() + headerLength);
        return buffer;
    }

    public ByteBuffer getReplyByteBuffer(int size) {
        int headerLength = 12;
        ByteBuffer buffer = this.endpoint14.createByteBuffer(size + headerLength);
        buffer.position(buffer.position() + headerLength);
        return buffer;
    }

    public ByteBuffer getReplyRequestByteBuffer(int size) {
        int headerLength = 16;
        ByteBuffer buffer = this.endpoint14.createByteBuffer(size + headerLength);
        buffer.position(buffer.position() + headerLength);
        return buffer;
    }

    public boolean writeReply(ByteBuffer obj, ReplyListener replyListener) throws IOException {
        Integer seqInt = (Integer)currentReplySequence.get();
        if (seqInt == null) {
            throw new RuntimeException("No reply sequence in this thread");
        }
        return this.writeReply(obj, (int)seqInt, replyListener);
    }

    public boolean writeReply(ByteBuffer obj, int seqInt, ReplyListener replyListener) throws IOException {
        byte[] replyHeader = this.getReplyHeader(seqInt, replyListener);
        boolean result = this.endpoint14.write(obj, replyHeader);
        if (logger.isLoggable(JeusMessage_Network._414_LEVEL)) {
            logger.log(JeusMessage_Network._414_LEVEL, JeusMessage_Network._414, new Object[]{obj, this.socketString});
        }
        return result;
    }

    public boolean writeReply(ByteBuffer obj) throws IOException {
        Integer seqInt = (Integer)currentReplySequence.get();
        if (seqInt == null) {
            throw new RuntimeException("No reply sequence in this thread");
        }
        return this.writeReply(obj, (int)seqInt, null);
    }

    public boolean writeReply(ByteBuffer obj, int replyID) throws IOException {
        return this.writeReply(obj, replyID, null);
    }

    public boolean write(Object message, ReplyListener receiver) throws IOException {
        if (message instanceof ByteBuffer) {
            return this.write((ByteBuffer)message, receiver);
        }
        return super.write(message, receiver);
    }

    public boolean write(Object message) throws IOException {
        if (message instanceof ByteBuffer) {
            return this.write((ByteBuffer)message);
        }
        return super.write(message);
    }

    public boolean writeReply(Object obj) throws IOException {
        if (obj instanceof ByteBuffer) {
            return this.writeReply((ByteBuffer)obj);
        }
        return super.writeReply(obj);
    }

    public boolean writeReply(Object obj, int replyID) throws IOException {
        if (obj instanceof ByteBuffer) {
            return this.writeReply((ByteBuffer)obj, replyID);
        }
        return super.writeReply(obj, replyID);
    }

    public boolean writeReply(Object obj, ReplyListener replyListener) throws IOException {
        if (obj instanceof ByteBuffer) {
            return this.writeReply((ByteBuffer)obj, replyListener);
        }
        return super.writeReply(obj, replyListener);
    }

    public boolean writeReply(Object obj, int seqInt, ReplyListener replyListener) throws IOException {
        if (obj instanceof ByteBuffer) {
            return this.writeReply((ByteBuffer)obj, seqInt, replyListener);
        }
        return super.writeReply(obj, seqInt, replyListener);
    }
}

