/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.DataInput;
import java.io.IOException;

public class ByteUtil {
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'D'};

    public static String toHexString(byte[] bytes) {
        StringBuffer buffer = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            int unsignedValue = ByteUtil.convertByteToUnsigned(bytes[i]);
            buffer.append(digits[unsignedValue >> 4]);
            buffer.append(digits[unsignedValue & 0xF]);
        }
        return buffer.toString();
    }

    public static byte[] convertToBytes(short value) {
        byte[] bytes = new byte[2];
        ByteUtil.putUnsingedShort(bytes, 0, value);
        return bytes;
    }

    public static byte[] convertToByte(int value) {
        byte[] bytes = new byte[4];
        ByteUtil.putInt(bytes, 0, value);
        return bytes;
    }

    public static byte[] convertToByte(long value) {
        byte[] bytes = new byte[8];
        ByteUtil.putLong(bytes, 0, value);
        return bytes;
    }

    public static int convertToInt(byte[] bytes) {
        return ByteUtil.convertToInt(bytes, 0);
    }

    public static int convertToInt(byte[] buf, int off) {
        return ((buf[off] & 0xFF) << 24) + ((buf[1 + off] & 0xFF) << 16) + ((buf[2 + off] & 0xFF) << 8) + (buf[3 + off] & 0xFF);
    }

    private static int convertByteToUnsigned(int i) {
        return i & 0xFF;
    }

    public static void putInt(byte[] contents, int offset, int value) {
        contents[offset] = (byte)(value >>> 24 & 0xFF);
        contents[offset + 1] = (byte)(value >>> 16 & 0xFF);
        contents[offset + 2] = (byte)(value >>> 8 & 0xFF);
        contents[offset + 3] = (byte)(value & 0xFF);
    }

    public static void putLong(byte[] buf, int off, long v) {
        buf[off + 7] = (byte)(v & 0xFFL);
        buf[off + 6] = (byte)(v >>> 8 & 0xFFL);
        buf[off + 5] = (byte)(v >>> 16 & 0xFFL);
        buf[off + 4] = (byte)(v >>> 24 & 0xFFL);
        buf[off + 3] = (byte)(v >>> 32 & 0xFFL);
        buf[off + 2] = (byte)(v >>> 40 & 0xFFL);
        buf[off + 1] = (byte)(v >>> 48 & 0xFFL);
        buf[off] = (byte)(v >>> 56 & 0xFFL);
    }

    public static long convertToLong(byte[] buf) {
        return ByteUtil.convertToLong(buf, 0);
    }

    public static long convertToLong(byte[] buf, int off) {
        return ((long)buf[off] << 56) + ((long)(buf[1 + off] & 0xFF) << 48) + ((long)(buf[2 + off] & 0xFF) << 40) + ((long)(buf[3 + off] & 0xFF) << 32) + ((long)(buf[4 + off] & 0xFF) << 24) + (long)((buf[5 + off] & 0xFF) << 16) + (long)((buf[6 + off] & 0xFF) << 8) + (long)(buf[7 + off] & 0xFF);
    }

    public static int convertToUnsignedShort(byte[] id, int offset) {
        return ((id[offset] & 0xFF) << 8) + (id[offset + 1] & 0xFF);
    }

    public static void putUnsingedShort(byte[] contents, int offset, int value) {
        contents[offset] = (byte)(value >>> 8 & 0xFF);
        contents[offset + 1] = (byte)(value & 0xFF);
    }

    public static int getHashCode(byte[] gtid) {
        int hashCode = 0;
        for (int i = 0; i < gtid.length; ++i) {
            hashCode ^= gtid[i];
        }
        return hashCode;
    }

    public static byte[] readByteArray(DataInput din) throws IOException {
        int length = ByteUtil.readInt(din);
        byte[] gtid = new byte[length];
        din.readFully(gtid, 0, length);
        return gtid;
    }

    public static int readInt(DataInput din) throws IOException {
        byte[] lengthByte = new byte[4];
        din.readFully(lengthByte, 0, 4);
        return ByteUtil.convertToInt(lengthByte);
    }

    public static int writeByteArray(byte[] temp, int offset, byte[] gtid) {
        ByteUtil.putInt(temp, offset, gtid.length);
        System.arraycopy(gtid, 0, temp, offset += 4, gtid.length);
        return offset + gtid.length;
    }
}

