/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import jeus.util.JeusBootstrapPropertyValues;

public class JeusOutputStreamWriter
extends Writer {
    private String charsetName;
    private static final int PADDING = 100;
    private int bufferSize;
    private volatile StringBuffer buffer;
    private final OutputStream output;
    private final Object bufferChangeLock = new Object();

    public JeusOutputStreamWriter(OutputStream out, String charsetName, int bufferSize) {
        super(out);
        this.output = out;
        if (charsetName == null) {
            charsetName = JeusBootstrapPropertyValues.FILE_ENCODING;
        }
        this.charsetName = charsetName;
        this.bufferSize = bufferSize;
        this.buffer = new StringBuffer(bufferSize + 100);
    }

    public JeusOutputStreamWriter(OutputStream out) {
        this(out, null, 0);
    }

    public JeusOutputStreamWriter(OutputStream out, int size) {
        this(out, null, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        StringBuffer writeBuffer;
        Object object = this.bufferChangeLock;
        synchronized (object) {
            writeBuffer = this.buffer;
            this.buffer = new StringBuffer(this.bufferSize + 100);
        }
        this.writeBuffer(writeBuffer);
    }

    public void write(int c) throws IOException {
        this.buffer.append((char)c);
        this.checkFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFlush() {
        if (this.buffer.length() > this.bufferSize) {
            StringBuffer writeBuffer = null;
            Object object = this.bufferChangeLock;
            synchronized (object) {
                if (this.buffer.length() > this.bufferSize) {
                    writeBuffer = this.buffer;
                    this.buffer = new StringBuffer(this.bufferSize + 100);
                }
            }
            if (writeBuffer != null) {
                this.writeBuffer(writeBuffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBuffer(StringBuffer writeBuffer) {
        OutputStream outputStream = this.output;
        synchronized (outputStream) {
            try {
                this.output.write(writeBuffer.toString().getBytes(this.charsetName));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.buffer.append(cbuf, off, len);
        this.checkFlush();
    }

    public void write(char[] cbuf) throws IOException {
        this.buffer.append(cbuf);
        this.checkFlush();
    }

    public void write(String str, int off, int len) throws IOException {
        this.write(str.substring(off, off + len));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str) throws IOException {
        if (this.bufferSize > 0) {
            this.buffer.append(str);
            this.checkFlush();
        } else {
            OutputStream outputStream = this.output;
            synchronized (outputStream) {
                try {
                    this.output.write(str.getBytes(this.charsetName));
                }
                catch (RuntimeException ex) {
                    System.out.println("skip runtime exception");
                    ex.printStackTrace();
                }
            }
        }
    }

    public void close() throws IOException {
        this.buffer = null;
        this.output.close();
    }
}

