/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.util.ArrayList;
import java.util.List;
import jeus.util.CommonExecutor;
import jeus.util.JeusRunnable;
import jeus.util.JeusThread;
import jeus.util.JeusThreadFactory;
import jeus.util.ShutdownHandler;
import jeus.util.concurrent.Channel;
import jeus.util.concurrent.PooledExecutor;

public class JeusRefinedPooledExecutor
extends PooledExecutor
implements CommonExecutor {
    private int workingThread;
    private int initPoolSize_;
    protected String poolName;

    protected JeusRefinedPooledExecutor(String threadNamePrefix, int maxPoolSize) {
        super(maxPoolSize);
        this.poolName = threadNamePrefix;
        this.setThreadFactory(new JeusThreadFactory(threadNamePrefix));
    }

    protected JeusRefinedPooledExecutor(String threadNamePrefix, Channel channel, int maxPoolSize) {
        super(channel, maxPoolSize);
        this.poolName = threadNamePrefix;
        this.setThreadFactory(new JeusThreadFactory(threadNamePrefix));
    }

    JeusRefinedPooledExecutor() {
    }

    protected JeusRefinedPooledExecutor(String threadNamePrefix) {
        this.poolName = threadNamePrefix;
        this.setThreadFactory(new JeusThreadFactory(threadNamePrefix));
    }

    protected JeusRefinedPooledExecutor(String threadNamePrefix, Channel executorQueue) {
        super(executorQueue);
        this.poolName = threadNamePrefix;
        this.setThreadFactory(new JeusThreadFactory(threadNamePrefix));
    }

    public void setInitPoolSize(int initPoolSize) {
        this.initPoolSize_ = initPoolSize;
        this.createThreads(initPoolSize);
    }

    public void setDaemon() {
        ((JeusThreadFactory)this.threadFactory_).setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Runnable getTask() throws InterruptedException {
        long waitTime;
        JeusRefinedPooledExecutor jeusRefinedPooledExecutor = this;
        synchronized (jeusRefinedPooledExecutor) {
            JeusThread jeusThread;
            Thread t;
            if (this.poolSize_ > this.maximumPoolSize_) {
                return null;
            }
            waitTime = this.shutdown_ ? 0L : ((t = Thread.currentThread()) instanceof JeusThread ? ((jeusThread = (JeusThread)t).getSequence() < this.initPoolSize_ ? -1L : this.keepAliveTime_) : this.keepAliveTime_);
        }
        Runnable r = waitTime >= 0L ? (Runnable)this.handOff_.poll(waitTime) : (Runnable)this.handOff_.take();
        if (r != null) {
            JeusRefinedPooledExecutor jeusRefinedPooledExecutor2 = this;
            synchronized (jeusRefinedPooledExecutor2) {
                ++this.workingThread;
            }
        }
        return r;
    }

    protected void beginRunnable(Runnable runnable) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endRunnable(boolean isJeusThread) {
        JeusRefinedPooledExecutor jeusRefinedPooledExecutor = this;
        synchronized (jeusRefinedPooledExecutor) {
            --this.workingThread;
        }
    }

    protected void addThread(Runnable command) {
        if (command != null) {
            ++this.workingThread;
        }
        super.addThread(command);
    }

    public void execute(Runnable command) throws InterruptedException {
        command = this.makeRunnable(command);
        this.executeInternal(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInternal(Runnable command) throws InterruptedException {
        do {
            JeusRefinedPooledExecutor jeusRefinedPooledExecutor = this;
            synchronized (jeusRefinedPooledExecutor) {
                if (!this.shutdown_) {
                    int size = this.poolSize_;
                    if (this.workingThread == size && size < this.minimumPoolSize_) {
                        this.addThread(command);
                        return;
                    }
                    this.beforeQueueing(command);
                    if (this.handOff_.offer(command, 0L)) {
                        return;
                    }
                    if (size < this.maximumPoolSize_) {
                        this.addThread(command);
                        return;
                    }
                }
            }
        } while (!this.getBlockedExecutionHandler().blockedAction(command));
    }

    protected void beforeQueueing(Runnable command) {
    }

    protected Runnable makeRunnable(Runnable command) {
        return new JeusRunnable(this, command);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(32);
        buf.append("Executor[name:").append(this.poolName).append("/min:").append(this.minimumPoolSize_).append("/max:").append(this.maximumPoolSize_).append("/init:").append(this.initPoolSize_).append("/keep:").append(this.keepAliveTime_).append("msec]");
        return buf.toString();
    }

    public void shutdownNow(ShutdownHandler handler) {
        this.shutdownNow();
    }

    public int getWorkingSize() {
        return this.workingThread;
    }

    public int getActiveCount() {
        return this.getWorkingSize();
    }

    public List drain() {
        List list = super.drain();
        ArrayList<Runnable> newList = new ArrayList<Runnable>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            JeusRunnable jeusRunnable = (JeusRunnable)list.get(i);
            newList.add(jeusRunnable.getRunnable());
        }
        return newList;
    }
}

