/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import jeus.util.properties.JeusNetProperties;

public class JeusSocket {
    public static Socket getConnection(String host, int port, int timeout) throws UnknownHostException, IOException, InterruptedIOException {
        return JeusSocket.getConnection(host, port, timeout, false, null);
    }

    public static Socket getConnection(String host, int port, int timeout, boolean isJavaChannel, SSLContext sslContext) throws UnknownHostException, IOException, InterruptedIOException {
        return JeusSocket.getConnection(host, port, null, 0, timeout, isJavaChannel, sslContext);
    }

    public static Socket getConnection(String host, int port, String localHost, int localPort, int timeout, boolean isJavaChannel, SSLContext sslContext) throws UnknownHostException, IOException, InterruptedIOException {
        if (timeout < 0) {
            timeout = 0;
        }
        Socket socket = null;
        try {
            if (isJavaChannel) {
                SocketChannel channel = SocketChannel.open();
                socket = channel.socket();
            } else {
                socket = sslContext != null ? sslContext.getSocketFactory().createSocket() : new Socket();
            }
            if (localHost != null && localPort > 0) {
                socket.bind(new InetSocketAddress(localHost, localPort));
            } else if (localHost == null && localPort > 0) {
                socket.bind(new InetSocketAddress(localPort));
            }
            if (JeusNetProperties.IBM_BUG_VERSION) {
                socket.connect(new InetSocketAddress(host, port));
            } else {
                socket.connect(new InetSocketAddress(host, port), timeout);
            }
            if (isJavaChannel) {
                socket.getChannel().configureBlocking(true);
            }
            if (sslContext != null && !isJavaChannel) {
                ((SSLSocket)socket).startHandshake();
            }
        }
        catch (InterruptedIOException iie) {
            JeusSocket.destroySocket(socket);
            throw iie;
        }
        catch (IOException ioe) {
            JeusSocket.destroySocket(socket);
            throw ioe;
        }
        catch (RuntimeException re) {
            JeusSocket.destroySocket(socket);
            throw re;
        }
        return socket;
    }

    private static void destroySocket(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.shutdownInput();
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            socket.shutdownOutput();
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

