/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.IOException;
import jeus.net.Endpoint;
import jeus.net.NetworkControlPacket;
import jeus.net.ReplyListener;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.net.helper.MsgSync;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Network;
import jeus.util.properties.JeusNetProperties;
import jeus.util.scheduler.ScheduleTask;

public class PingTimerTask
extends ScheduleTask {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.net");
    private final Endpoint endpoint;
    private final SocketID mySocketID;
    private final NetworkControlPacket pingPacket;

    public PingTimerTask(Endpoint endpoint) {
        this.endpoint = endpoint;
        this.mySocketID = endpoint.getMySocketID();
        this.pingPacket = new NetworkControlPacket(5);
        this.pingPacket.setSocketID(this.mySocketID);
    }

    public void run() {
        if (this.endpoint.isExported()) {
            int i;
            SocketStream[] servers = this.endpoint.getConnectionManager().getSocketStreams();
            MsgSync[] syncs = new MsgSync[servers.length];
            for (i = 0; i < servers.length; ++i) {
                SocketStream server = servers[i];
                if (!this.mySocketID.needConnect(server.getSocketID())) continue;
                try {
                    MsgSync sync = new MsgSync(JeusNetProperties.PING_TIMEOUT);
                    server.write(this.pingPacket, (ReplyListener)sync);
                    syncs[i] = sync;
                    continue;
                }
                catch (IOException e) {
                    if (logger.isLoggable(JeusMessage_Network._1000_LEVEL)) {
                        logger.log(JeusMessage_Network._1000_LEVEL, JeusMessage_Network._1000, server.getSocketID(), (Throwable)e);
                    }
                    this.endpoint.getConnectionManager().remove(server);
                }
            }
            for (i = 0; i < syncs.length; ++i) {
                MsgSync sync = syncs[i];
                if (sync == null) continue;
                try {
                    Object returnValue = sync.waitReply();
                    if (!(returnValue instanceof NetworkControlPacket) || ((NetworkControlPacket)returnValue).getCode() != 6) {
                        throw new IOException("did not received ping packet");
                    }
                    continue;
                }
                catch (IOException e) {
                    SocketStream server = servers[i];
                    if (logger.isLoggable(JeusMessage_Network._1001_LEVEL)) {
                        logger.log(JeusMessage_Network._1001_LEVEL, JeusMessage_Network._1001, server.getSocketID(), (Throwable)e);
                    }
                    server.destroy();
                }
            }
        }
    }
}

