/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.cnet;

public class NetUtil {
    public static final int SIZE_IPv4_ADDR = 4;
    public static final int SIZE_IPv6_ADDR = 16;

    public static void writeShort(byte[] buf, int off, int v) {
        buf[off + 0] = (byte)(v >> 8 & 0xFF);
        buf[off + 1] = (byte)(v & 0xFF);
    }

    public static void writeInt(byte[] buf, int off, int v) {
        buf[off + 0] = (byte)(v >> 24 & 0xFF);
        buf[off + 1] = (byte)(v >> 16 & 0xFF);
        buf[off + 2] = (byte)(v >> 8 & 0xFF);
        buf[off + 3] = (byte)(v & 0xFF);
    }

    public static void writeInt(byte[] buf, int off, int v, boolean isLittleEndian) {
        if (isLittleEndian) {
            buf[off + 3] = (byte)(v >> 24 & 0xFF);
            buf[off + 2] = (byte)(v >> 16 & 0xFF);
            buf[off + 1] = (byte)(v >> 8 & 0xFF);
            buf[off + 0] = (byte)(v & 0xFF);
        } else {
            buf[off + 0] = (byte)(v >> 24 & 0xFF);
            buf[off + 1] = (byte)(v >> 16 & 0xFF);
            buf[off + 2] = (byte)(v >> 8 & 0xFF);
            buf[off + 3] = (byte)(v & 0xFF);
        }
    }

    public static void writeLong(byte[] buf, int off, long v) {
        buf[off + 7] = (byte)(v & 0xFFL);
        buf[off + 6] = (byte)(v >>> 8 & 0xFFL);
        buf[off + 5] = (byte)(v >>> 16 & 0xFFL);
        buf[off + 4] = (byte)(v >>> 24 & 0xFFL);
        buf[off + 3] = (byte)(v >>> 32 & 0xFFL);
        buf[off + 2] = (byte)(v >>> 40 & 0xFFL);
        buf[off + 1] = (byte)(v >>> 48 & 0xFFL);
        buf[off + 0] = (byte)(v >>> 56 & 0xFFL);
    }

    public static short readShort(byte[] buf, int off) {
        int ch1 = buf[off] & 0xFF;
        int ch2 = buf[off + 1] & 0xFF;
        return (short)((ch1 << 8) + ch2);
    }

    public static int readInt(byte[] buf, int off) {
        int ch1 = buf[off] & 0xFF;
        int ch2 = buf[off + 1] & 0xFF;
        int ch3 = buf[off + 2] & 0xFF;
        int ch4 = buf[off + 3] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    public static long readLong(byte[] buf, int off) {
        return ((long)NetUtil.readInt(buf, off) << 32) + ((long)NetUtil.readInt(buf, off + 4) & 0xFFFFFFFFL);
    }

    public static String getIPAddrString(byte[] ipaddr) {
        if (ipaddr.length == 4) {
            return Integer.toString(ipaddr[0] & 0xFF) + "." + Integer.toString(ipaddr[1] & 0xFF) + "." + Integer.toString(ipaddr[2] & 0xFF) + "." + Integer.toString(ipaddr[3] & 0xFF);
        }
        return Integer.toHexString(ipaddr[0] & 0xFF) + Integer.toHexString(ipaddr[1] & 0xFF) + ":" + Integer.toHexString(ipaddr[2] & 0xFF) + Integer.toHexString(ipaddr[3] & 0xFF) + ":" + Integer.toHexString(ipaddr[4] & 0xFF) + Integer.toHexString(ipaddr[5] & 0xFF) + ":" + Integer.toHexString(ipaddr[6] & 0xFF) + Integer.toHexString(ipaddr[7] & 0xFF) + ":" + Integer.toHexString(ipaddr[8] & 0xFF) + Integer.toHexString(ipaddr[9] & 0xFF) + ":" + Integer.toHexString(ipaddr[10] & 0xFF) + Integer.toHexString(ipaddr[11] & 0xFF) + ":" + Integer.toHexString(ipaddr[12] & 0xFF) + Integer.toHexString(ipaddr[13] & 0xFF) + ":" + Integer.toHexString(ipaddr[14] & 0xFF) + Integer.toHexString(ipaddr[15] & 0xFF);
    }

    public static int isLargeAddress(byte[] own, byte[] target) {
        if (own.length > target.length) {
            return 1;
        }
        for (int i = 0; i < own.length; ++i) {
            if (own[i] > target[i]) {
                return 1;
            }
            if (own[i] >= target[i]) continue;
            return -1;
        }
        return 0;
    }
}

