/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.concurrent;

import jeus.util.concurrent.Sync;

public class CondVar {
    protected final Sync mutex_;

    public CondVar(Sync mutex) {
        this.mutex_ = mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                this.mutex_.release();
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }
        finally {
            boolean interrupted = false;
            while (true) {
                try {
                    this.mutex_.acquire();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean timedwait(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean success = false;
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                this.mutex_.release();
                try {
                    if (msecs > 0L) {
                        long start = System.currentTimeMillis();
                        this.wait(msecs);
                        success = System.currentTimeMillis() - start <= msecs;
                    }
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }
        finally {
            boolean interrupted = false;
            while (true) {
                try {
                    this.mutex_.acquire();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return success;
    }

    public synchronized void signal() {
        this.notify();
    }

    public synchronized void broadcast() {
        this.notifyAll();
    }
}

